/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellCheckerListener
extends SpellCheckAdapter {
    private ErrorMarker errorMarker;

    public RealTimeSpellCheckerListener(JTextComponent textComponent) {
        this.errorMarker = new ErrorMarker(textComponent, false);
    }

    public void spellingError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getSpellingErrorInfo(event));
    }

    public void badCaseError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getBadCaseErrorInfo(event));
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getRepeatWordErrorInfo(event));
    }

    private void markError(SpellCheckEvent event, final ErrorInfo info) {
        final Word badWord = event.getCurrentWord();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        RealTimeSpellCheckerListener.this.errorMarker.markError(badWord.getStart(), badWord.getEnd(), info);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void beginChecking(SpellCheckEvent event) {
        SynchronizedWordFinder finder = (SynchronizedWordFinder)event.getWordFinder();
        final TextRange textRange = finder.getTextRange();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    RealTimeSpellCheckerListener.this.errorMarker.unMarkRange(textRange.getBegin(), textRange.getEnd());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanAllErrors() {
        this.errorMarker.quitTextComponent();
    }

    public ErrorMarker getErrorMarker() {
        return this.errorMarker;
    }
}

