/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.finder;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class DocumentCharSequence
implements CharSequence {
    private Position begin;
    private Position end;
    private Document document;

    public DocumentCharSequence() {
        this(null);
    }

    public DocumentCharSequence(Document doc, int begin, int end) {
        this.init(doc, begin, end);
    }

    public DocumentCharSequence(Document doc) {
        this.init(doc, 0, null != doc ? doc.getLength() : 0);
    }

    public int length() {
        if (null == this.document) {
            return 0;
        }
        if (null != this.end) {
            return this.end.getOffset() - this.begin.getOffset();
        }
        return this.document.getLength() - this.begin.getOffset();
    }

    public char charAt(int index) {
        try {
            return this.document.getText(this.begin.getOffset() + index, 1).charAt(0);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    public CharSequence subSequence(int start, int end) {
        return new DocumentCharSequence(this.document, this.begin.getOffset() + start, this.begin.getOffset() + end);
    }

    public String toString() {
        try {
            if (null != this.document) {
                return this.document.getText(this.begin.getOffset(), this.length());
            }
            return "";
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document doc) {
        this.init(doc, 0, null != doc ? doc.getLength() : 0);
    }

    void updateFromDocument(Document doc) {
        this.setDocument(doc);
    }

    private void init(Document doc, int begin, int end) {
        this.document = doc;
        if (null != doc) {
            try {
                this.begin = doc.createPosition(begin);
                if (doc.getLength() != end) {
                    this.end = doc.createPosition(end);
                }
                this.end = null;
            }
            catch (BadLocationException e) {
                throw new IndexOutOfBoundsException(e.getLocalizedMessage());
            }
        } else {
            this.begin = null;
            this.end = null;
        }
    }
}

