/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.swing.utils.Messages;

public class ErrorPopUpMenu {
    private JPopupMenu NULL_POPUP = new NullPopup();
    private ErrorPopupMenuListener errorPopupMenuListener = new ErrorPopupMenuListener();
    private Hashtable<JTextComponent, PopupMenuInfo> currentEditors = new Hashtable();

    public void addErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        this.currentEditors.put(textComponent, new PopupMenuInfo(errorMarker, textComponent));
        textComponent.addMouseMotionListener(this.errorPopupMenuListener);
        textComponent.getComponentPopupMenu().addPopupMenuListener(this.errorPopupMenuListener);
    }

    public void removeErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        PopupMenuInfo info = this.currentEditors.get(textComponent);
        textComponent.removePropertyChangeListener(info);
        this.currentEditors.remove(textComponent);
        textComponent.getComponentPopupMenu().removePopupMenuListener(this.errorPopupMenuListener);
        textComponent.removeMouseMotionListener(this.errorPopupMenuListener);
        if (null == info.originalPopup) {
            textComponent.setComponentPopupMenu(null);
        }
    }

    public PopupMenuInfo getPopupMenuInfo(JPopupMenu popup) {
        return this.currentEditors.get((JTextComponent)popup.getInvoker());
    }

    protected void mergeWithErrorPopupMenuItems(JPopupMenu popup) {
        JTextComponent textCmp = (JTextComponent)popup.getInvoker();
        PopupMenuInfo popupInfo = this.currentEditors.get(textCmp);
        ErrorMarker marker = popupInfo.errorMarker;
        int pos = null != popupInfo.position ? textCmp.viewToModel(popupInfo.position) : textCmp.getCaretPosition();
        this.mergeWithErrorPopupMenu(marker, pos);
    }

    protected void deleteErrorPopupMenuItems(JPopupMenu menu) {
        ErrorPopUpMenu.cleanErrorPopupMenu(menu);
    }

    public void mergeWithErrorPopupMenu(ErrorMarker marker, int position) {
        ErrorInfo info = marker.getErrorInfo(position);
        if (null != info) {
            this.getErrorPopupMenu(info, marker.getTextComponent());
        }
    }

    public JPopupMenu getErrorPopupMenu(ErrorInfo info, JTextComponent textComponent) {
        return this.mergeWithErrorPopupMenu(info.getBadWord(), info.getSuggestions(), textComponent);
    }

    protected JMenuItem createRemplaceMenuItem(Word badWord, String suggestion, JTextComponent textComponent) {
        return new ReplaceErrorMenuItem(badWord, textComponent, suggestion);
    }

    protected JMenuItem createRemoveMenuItem(Word badWord, JTextComponent textComponent) {
        return new ReplaceErrorMenuItem(badWord, textComponent);
    }

    public JPopupMenu mergeWithErrorPopupMenu(Word badWord, String[] suggestions, JTextComponent textComponent) {
        JPopupMenu result = textComponent.getComponentPopupMenu();
        if (null == suggestions) {
            if (result.getSubElements().length > 0) {
                result.addSeparator();
            }
            result.add(this.createRemoveMenuItem(badWord, textComponent));
        } else if (suggestions.length > 0) {
            if (result.getSubElements().length > 0) {
                result.addSeparator();
            }
            for (String sg : suggestions) {
                result.add(this.createRemplaceMenuItem(badWord, sg, textComponent));
            }
        }
        return result;
    }

    public static JPopupMenu cleanErrorPopupMenu(JTextComponent textComponent) {
        return ErrorPopUpMenu.cleanErrorPopupMenu(textComponent.getComponentPopupMenu());
    }

    public static JPopupMenu cleanErrorPopupMenu(JPopupMenu menu) {
        int current = menu.getComponentCount() - 1;
        while (current >= 0) {
            Component cmp = menu.getComponent(current);
            if (cmp instanceof ReplaceErrorMenuItem) {
                menu.remove(cmp);
                --current;
                continue;
            }
            if (cmp instanceof JPopupMenu.Separator) {
                menu.remove(cmp);
            }
            current = -1;
        }
        return menu;
    }

    public static class ReplaceErrorMenuItem
    extends JMenuItem
    implements ActionListener {
        private JTextComponent textComponent;
        private Word badWord;
        private String suggestion;

        private static String getItemText(String suggestion, Word badWord) {
            if (suggestion.isEmpty()) {
                return Messages.getString("MENU_DELETE_WORD", badWord);
            }
            return Messages.getString("MENU_REPLACE_WORD", suggestion);
        }

        public ReplaceErrorMenuItem(Word badWord, JTextComponent textComponent) {
            this(badWord, textComponent, "");
        }

        public ReplaceErrorMenuItem(Word badWord, JTextComponent textComponent, String suggestion) {
            super(ReplaceErrorMenuItem.getItemText(suggestion, badWord));
            this.textComponent = textComponent;
            this.badWord = badWord;
            this.suggestion = suggestion;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.suggestion.isEmpty()) {
                    this.deleteWord(this.badWord, this.textComponent);
                } else {
                    this.remplaceWord(this.badWord, this.textComponent, this.suggestion);
                }
            }
            catch (Exception ex) {
                ErrorMsgBox.show((Component)this.textComponent, ex);
            }
        }

        public void remplaceWord(Word badWord, JTextComponent textComponent, String suggestion) {
            int end = badWord.getEnd();
            int start = badWord.getStart();
            textComponent.select(start, end);
            textComponent.replaceSelection(suggestion);
        }

        public void deleteWord(Word badWord, JTextComponent textComponent) {
            int end = badWord.getEnd();
            int start = badWord.getStart();
            if (start > 0) {
                --start;
            }
            textComponent.select(start, end);
            textComponent.replaceSelection(this.suggestion);
        }
    }

    private class ErrorPopupMenuListener
    extends MouseMotionAdapter
    implements PopupMenuListener {
        private ErrorPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ErrorPopUpMenu.cleanErrorPopupMenu((JPopupMenu)e.getSource());
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ErrorPopUpMenu.this.deleteErrorPopupMenuItems((JPopupMenu)e.getSource());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            if (ErrorPopUpMenu.this.NULL_POPUP != popup) {
                ErrorPopUpMenu.this.mergeWithErrorPopupMenuItems(popup);
            }
        }

        public void mouseMoved(MouseEvent e) {
            PopupMenuInfo popupInfo = (PopupMenuInfo)ErrorPopUpMenu.this.currentEditors.get((JTextComponent)e.getSource());
            popupInfo.position = e.getPoint();
        }
    }

    public class PopupMenuInfo
    implements PropertyChangeListener {
        public ErrorMarker errorMarker;
        public JPopupMenu originalPopup;
        public Point position;

        public PopupMenuInfo(ErrorMarker marker, JTextComponent textComponent) {
            JComponent parent;
            this.errorMarker = marker;
            this.originalPopup = textComponent.getComponentPopupMenu();
            textComponent.addPropertyChangeListener("componentPopupMenu", this);
            if (null == this.originalPopup) {
                textComponent.setComponentPopupMenu(ErrorPopUpMenu.this.NULL_POPUP);
            }
            if (textComponent.getInheritsPopupMenu() && textComponent.getParent() instanceof JComponent && this.originalPopup == (parent = (JComponent)textComponent.getParent()).getComponentPopupMenu()) {
                this.originalPopup = null;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JPopupMenu newPopup = (JPopupMenu)evt.getNewValue();
            if (newPopup != this.originalPopup) {
                this.originalPopup = newPopup;
            }
        }
    }

    private class NullPopup
    extends JPopupMenu {
        private NullPopup() {
        }

        public void setVisible(boolean b) {
            if (b) {
                ErrorPopUpMenu.this.mergeWithErrorPopupMenuItems(this);
                if (this.getSubElements().length > 0) {
                    super.setVisible(b);
                }
            } else {
                super.setVisible(b);
            }
        }
    }
}

