/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.utils.ErrorMarker;

public class ErrorToolTips {
    private MouseMotionListener motionMouseListener = new MouseListener();
    private Hashtable<JTextComponent, TooltipInfo> currentEditors = new Hashtable();

    public void addErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        this.currentEditors.put(textComponent, new TooltipInfo(errorMarker, textComponent));
        textComponent.addMouseMotionListener(this.motionMouseListener);
    }

    public void removeErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        TooltipInfo info = this.currentEditors.get(textComponent);
        this.currentEditors.remove(textComponent);
        textComponent.removeMouseMotionListener(this.motionMouseListener);
        textComponent.removePropertyChangeListener(info);
    }

    public String getErrorMessage(ErrorMarker marker, int position) {
        ErrorInfo info = marker.getErrorInfo(position);
        if (null != info) {
            return info.getDescription();
        }
        return null;
    }

    private class MouseListener
    extends MouseMotionAdapter {
        private MouseListener() {
        }

        public void mouseMoved(MouseEvent e) {
            JTextComponent textCmp = (JTextComponent)e.getSource();
            int pos = textCmp.viewToModel(e.getPoint());
            TooltipInfo tooltipInfo = (TooltipInfo)ErrorToolTips.this.currentEditors.get(textCmp);
            ErrorMarker marker = tooltipInfo.errorMarker;
            String originalText = tooltipInfo.originalText;
            if (marker.hasError(pos)) {
                String errorText;
                tooltipInfo.originalText = errorText = ErrorToolTips.this.getErrorMessage(marker, pos);
                textCmp.setToolTipText(errorText);
            } else {
                textCmp.setToolTipText(originalText);
            }
            tooltipInfo.originalText = originalText;
        }
    }

    private static class TooltipInfo
    implements PropertyChangeListener {
        public ErrorMarker errorMarker;
        public String originalText;

        public TooltipInfo(ErrorMarker marker, JTextComponent textComponent) {
            this.errorMarker = marker;
            this.originalText = textComponent.getToolTipText();
            textComponent.addPropertyChangeListener("ToolTipText", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String newTooltip = (String)evt.getNewValue();
            if (newTooltip != this.originalText) {
                this.originalText = newTooltip;
            }
        }
    }
}

