/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.RelevantItemsDataSplitter;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;

public final class GenericRelevantItemsDataSplitter
implements RelevantItemsDataSplitter {
    @Override
    public FastIDSet getRelevantItemsIDs(long userID, int at, double relevanceThreshold, DataModel dataModel) throws TasteException {
        PreferenceArray prefs = dataModel.getPreferencesFromUser(userID);
        FastIDSet relevantItemIDs = new FastIDSet(at);
        prefs.sortByValueReversed();
        for (int i = 0; i < prefs.length() && relevantItemIDs.size() < at; ++i) {
            if (!((double)prefs.getValue(i) >= relevanceThreshold)) continue;
            relevantItemIDs.add(prefs.getItemID(i));
        }
        return relevantItemIDs;
    }

    @Override
    public void processOtherUser(long userID, FastIDSet relevantItemIDs, FastByIDMap<PreferenceArray> trainingUsers, long otherUserID, DataModel dataModel) throws TasteException {
        PreferenceArray prefs2Array = dataModel.getPreferencesFromUser(otherUserID);
        if (userID == otherUserID) {
            ArrayList prefs2 = Lists.newArrayListWithCapacity((int)prefs2Array.length());
            for (Preference pref : prefs2Array) {
                prefs2.add(pref);
            }
            Iterator iterator = prefs2.iterator();
            while (iterator.hasNext()) {
                Preference pref;
                pref = (Preference)iterator.next();
                if (!relevantItemIDs.contains(pref.getItemID())) continue;
                iterator.remove();
            }
            if (!prefs2.isEmpty()) {
                trainingUsers.put(otherUserID, new GenericUserPreferenceArray(prefs2));
            }
        } else {
            trainingUsers.put(otherUserID, prefs2Array);
        }
    }
}

