/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.eval.AbstractDifferenceRecommenderEvaluator;
import org.apache.mahout.cf.taste.impl.eval.LoadCallable;
import org.apache.mahout.cf.taste.impl.eval.LoadStatistics;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.Recommender;

public final class LoadEvaluator {
    private LoadEvaluator() {
    }

    public static LoadStatistics runLoad(Recommender recommender) throws TasteException {
        return LoadEvaluator.runLoad(recommender, 10);
    }

    public static LoadStatistics runLoad(Recommender recommender, int howMany) throws TasteException {
        DataModel dataModel = recommender.getDataModel();
        int numUsers = dataModel.getNumUsers();
        double sampleRate = 1000.0 / (double)numUsers;
        LongPrimitiveIterator userSampler = SamplingLongPrimitiveIterator.maybeWrapIterator(dataModel.getUserIDs(), sampleRate);
        recommender.recommend((Long)userSampler.next(), howMany);
        ArrayList callables = Lists.newArrayList();
        while (userSampler.hasNext()) {
            callables.add(new LoadCallable(recommender, (Long)userSampler.next()));
        }
        AtomicInteger noEstimateCounter = new AtomicInteger();
        FullRunningAverageAndStdDev timing = new FullRunningAverageAndStdDev();
        AbstractDifferenceRecommenderEvaluator.execute(callables, noEstimateCounter, timing);
        return new LoadStatistics(timing);
    }
}

