/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmEvaluator;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.LossyHmmSerializer;
import org.apache.mahout.common.CommandLineUtil;

public final class RandomSequenceGenerator {
    private RandomSequenceGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption outputOption = optionBuilder.withLongName("output").withDescription("Output file with sequence of observed states").withShortName("o").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("path").create()).withRequired(false).create();
        DefaultOption modelOption = optionBuilder.withLongName("model").withDescription("Path to serialized HMM model").withShortName("m").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("path").create()).withRequired(true).create();
        DefaultOption lengthOption = optionBuilder.withLongName("length").withDescription("Length of generated sequence").withShortName("l").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("number").create()).withRequired(true).create();
        Group optionGroup = new GroupBuilder().withOption((Option)outputOption).withOption((Option)modelOption).withOption((Option)lengthOption).withName("Options").create();
        try {
            HmmModel model;
            Parser parser = new Parser();
            parser.setGroup(optionGroup);
            CommandLine commandLine = parser.parse(args);
            String output = (String)commandLine.getValue((Option)outputOption);
            String modelPath = (String)commandLine.getValue((Option)modelOption);
            int length = Integer.parseInt((String)commandLine.getValue((Option)lengthOption));
            DataInputStream modelStream = new DataInputStream(new FileInputStream(modelPath));
            try {
                model = LossyHmmSerializer.deserialize(modelStream);
            }
            finally {
                Closeables.close((Closeable)modelStream, (boolean)true);
            }
            int[] observations = HmmEvaluator.predict(model, length, System.currentTimeMillis());
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8), true);
            try {
                for (int observation : observations) {
                    writer.print(observation);
                    writer.print(' ');
                }
            }
            finally {
                Closeables.close((Closeable)writer, (boolean)false);
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp(optionGroup);
        }
    }
}

