/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.fpgrowth2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.common.Pair;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public final class FPTree {
    private final AttrComparator attrComparator = new AttrComparator();
    private final FPNode root = new FPNode(null, -1, 0L);
    private final long minSupport;
    private final LongArrayList attrCountList;
    private final OpenIntObjectHashMap<List<FPNode>> attrNodeLists;

    public FPTree(LongArrayList attrCountList, long minSupport) {
        this.attrCountList = attrCountList;
        this.attrNodeLists = new OpenIntObjectHashMap();
        this.minSupport = minSupport;
    }

    public FPTree(long[] attrCounts, long minSupport) {
        this.attrCountList = new LongArrayList();
        for (int i = 0; i < attrCounts.length; ++i) {
            if (attrCounts[i] <= 0L) continue;
            if (this.attrCountList.size() < i + 1) {
                this.attrCountList.setSize(i + 1);
            }
            this.attrCountList.set(i, attrCounts[i]);
        }
        this.attrNodeLists = new OpenIntObjectHashMap();
        this.minSupport = minSupport;
    }

    public long headerCount(int attribute) {
        return this.attrCountList.get(attribute);
    }

    public FPNode root() {
        return this.root;
    }

    public void accumulate(IntArrayList argItems, long count) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < argItems.size(); ++i) {
            items.add(argItems.get(i));
        }
        Collections.sort(items, this.attrComparator);
        FPNode currNode = this.root;
        for (Integer item : items) {
            long attrCount = 0L;
            if (item < this.attrCountList.size()) {
                attrCount = this.attrCountList.get(item.intValue());
            }
            if (attrCount < this.minSupport) continue;
            FPNode next = currNode.child(item);
            if (next == null) {
                next = new FPNode(currNode, item, count);
                currNode.addChild(next);
                List nodeList = (List)this.attrNodeLists.get(item.intValue());
                if (nodeList == null) {
                    nodeList = Lists.newArrayList();
                    this.attrNodeLists.put(item.intValue(), (Object)nodeList);
                }
                nodeList.add(next);
            } else {
                next.accumulate(count);
            }
            currNode = next;
        }
    }

    public void accumulate(List<Integer> argItems, long count) {
        ArrayList items = Lists.newArrayList();
        items.addAll(argItems);
        Collections.sort(items, this.attrComparator);
        FPNode currNode = this.root;
        for (Integer item : items) {
            long attrCount = this.attrCountList.get(item.intValue());
            if (attrCount < this.minSupport) continue;
            FPNode next = currNode.child(item);
            if (next == null) {
                next = new FPNode(currNode, item, count);
                currNode.addChild(next);
                List nodeList = (List)this.attrNodeLists.get(item.intValue());
                if (nodeList == null) {
                    nodeList = Lists.newArrayList();
                    this.attrNodeLists.put(item.intValue(), (Object)nodeList);
                }
                nodeList.add(next);
            } else {
                next.accumulate(count);
            }
            currNode = next;
        }
    }

    public Iterable<Integer> attrIterableRev() {
        ArrayList attrs = Lists.newArrayList();
        for (int i = 0; i < this.attrCountList.size(); ++i) {
            if (this.attrCountList.get(i) <= 0L) continue;
            attrs.add(i);
        }
        Collections.sort(attrs, Collections.reverseOrder(this.attrComparator));
        return attrs;
    }

    public FPTree createMoreFreqConditionalTree(int targetAttr) {
        LongArrayList counts = new LongArrayList();
        List nodeList = (List)this.attrNodeLists.get(targetAttr);
        Iterator i$ = nodeList.iterator();
        while (i$.hasNext()) {
            FPNode currNode;
            long pathCount = currNode.count();
            for (currNode = (FPNode)i$.next(); currNode != this.root; currNode = currNode.parent()) {
                int currAttr = currNode.attribute();
                if (counts.size() <= currAttr) {
                    counts.setSize(currAttr + 1);
                }
                long count = counts.get(currAttr);
                counts.set(currNode.attribute(), count + pathCount);
            }
        }
        if (counts.get(targetAttr) != this.attrCountList.get(targetAttr)) {
            throw new IllegalStateException("mismatched counts for targetAttr=" + targetAttr + ", (" + counts.get(targetAttr) + " != " + this.attrCountList.get(targetAttr) + "); " + "thisTree=" + this + '\n');
        }
        counts.set(targetAttr, 0L);
        FPTree toRet = new FPTree(counts, this.minSupport);
        IntArrayList attrLst = new IntArrayList();
        Iterator i$2 = ((List)this.attrNodeLists.get(targetAttr)).iterator();
        while (i$2.hasNext()) {
            FPNode currNode;
            long count = currNode.count();
            attrLst.clear();
            for (currNode = (FPNode)i$2.next(); currNode != this.root; currNode = currNode.parent()) {
                if (currNode.count() < count) {
                    throw new IllegalStateException();
                }
                attrLst.add(currNode.attribute());
            }
            toRet.accumulate(attrLst, count);
        }
        return toRet;
    }

    public Pair<FPTree, FPTree> splitSinglePrefix() {
        if (this.root.numChildren() != 1) {
            return new Pair<Object, FPTree>(null, this);
        }
        LongArrayList pAttrCountList = new LongArrayList();
        LongArrayList qAttrCountList = this.attrCountList.copy();
        FPNode currNode = this.root;
        while (currNode.numChildren() == 1) {
            currNode = currNode.children().iterator().next();
            if (pAttrCountList.size() <= currNode.attribute()) {
                pAttrCountList.setSize(currNode.attribute() + 1);
            }
            pAttrCountList.set(currNode.attribute(), currNode.count());
            qAttrCountList.set(currNode.attribute(), 0L);
        }
        FPTree pTree = new FPTree(pAttrCountList, this.minSupport);
        FPTree qTree = new FPTree(qAttrCountList, this.minSupport);
        this.recursivelyAddPrefixPats(pTree, qTree, this.root, null);
        return new Pair<FPTree, FPTree>(pTree, qTree);
    }

    private long recursivelyAddPrefixPats(FPTree pTree, FPTree qTree, FPNode node, IntArrayList items) {
        long count = node.count();
        int attribute = node.attribute();
        if (items == null) {
            if (node != this.root) {
                throw new IllegalStateException();
            }
            items = new IntArrayList();
        } else {
            items.add(attribute);
        }
        long added = 0L;
        for (FPNode child : node.children()) {
            added += this.recursivelyAddPrefixPats(pTree, qTree, child, items);
        }
        if (added < count) {
            long toAdd = count - added;
            pTree.accumulate(items, toAdd);
            qTree.accumulate(items, toAdd);
            added += toAdd;
        }
        if (node != this.root) {
            int lastIdx = items.size() - 1;
            if (items.get(lastIdx) != attribute) {
                throw new IllegalStateException();
            }
            items.remove(lastIdx);
        }
        return added;
    }

    private static void toStringHelper(StringBuilder sb, FPNode currNode, String prefix) {
        if (currNode.numChildren() == 0) {
            sb.append(prefix).append("-{attr:").append(currNode.attribute()).append(", cnt:").append(currNode.count()).append("}\n");
        } else {
            StringBuilder newPre = new StringBuilder(prefix);
            newPre.append("-{attr:").append(currNode.attribute()).append(", cnt:").append(currNode.count()).append('}');
            StringBuilder fakePre = new StringBuilder();
            while (fakePre.length() < newPre.length()) {
                fakePre.append(' ');
            }
            int i = 0;
            for (FPNode child : currNode.children()) {
                FPTree.toStringHelper(sb, child, (i++ == 0 ? newPre : fakePre).toString() + '-' + i + "->");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[FPTree\n");
        FPTree.toStringHelper(sb, this.root, "  ");
        sb.append(']');
        return sb.toString();
    }

    private class AttrComparator
    implements Comparator<Integer> {
        private AttrComparator() {
        }

        @Override
        public int compare(Integer a, Integer b) {
            long aCnt = 0L;
            if (a < FPTree.this.attrCountList.size()) {
                aCnt = FPTree.this.attrCountList.get(a.intValue());
            }
            long bCnt = 0L;
            if (b < FPTree.this.attrCountList.size()) {
                bCnt = FPTree.this.attrCountList.get(b.intValue());
            }
            if (aCnt == bCnt) {
                return a - b;
            }
            return bCnt - aCnt < 0L ? -1 : 1;
        }
    }

    public static final class FPNode {
        private final FPNode parent;
        private final OpenIntObjectHashMap<FPNode> childMap;
        private final int attribute;
        private long count;

        private FPNode(FPNode parent, int attribute, long count) {
            this.parent = parent;
            this.attribute = attribute;
            this.count = count;
            this.childMap = new OpenIntObjectHashMap();
        }

        private void addChild(FPNode child) {
            this.childMap.put(child.attribute(), (Object)child);
        }

        public Iterable<FPNode> children() {
            return this.childMap.values();
        }

        public int numChildren() {
            return this.childMap.size();
        }

        public FPNode parent() {
            return this.parent;
        }

        public FPNode child(int attribute) {
            return (FPNode)this.childMap.get(attribute);
        }

        public int attribute() {
            return this.attribute;
        }

        public void accumulate(long incr) {
            this.count += incr;
        }

        public long count() {
            return this.count;
        }
    }
}

