/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.join.CompositeInputFormat;
import org.apache.hadoop.mapred.join.TupleWritable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public class MatrixMultiplicationJob
extends AbstractJob {
    private static final String OUT_CARD = "output.vector.cardinality";

    public static Configuration createMatrixMultiplyJobConf(Path aPath, Path bPath, Path outPath, int outCardinality) {
        return MatrixMultiplicationJob.createMatrixMultiplyJobConf(new Configuration(), aPath, bPath, outPath, outCardinality);
    }

    public static Configuration createMatrixMultiplyJobConf(Configuration initialConf, Path aPath, Path bPath, Path outPath, int outCardinality) {
        JobConf conf = new JobConf(initialConf, MatrixMultiplicationJob.class);
        conf.setInputFormat(CompositeInputFormat.class);
        conf.set("mapred.join.expr", CompositeInputFormat.compose((String)"inner", SequenceFileInputFormat.class, (Path[])new Path[]{aPath, bPath}));
        conf.setInt(OUT_CARD, outCardinality);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        conf.setMapperClass(MatrixMultiplyMapper.class);
        conf.setCombinerClass(MatrixMultiplicationReducer.class);
        conf.setReducerClass(MatrixMultiplicationReducer.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(VectorWritable.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(VectorWritable.class);
        return conf;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new MatrixMultiplicationJob(), (String[])args);
    }

    public int run(String[] strings) throws Exception {
        this.addOption("numRowsA", "nra", "Number of rows of the first input matrix", true);
        this.addOption("numColsA", "nca", "Number of columns of the first input matrix", true);
        this.addOption("numRowsB", "nrb", "Number of rows of the second input matrix", true);
        this.addOption("numColsB", "ncb", "Number of columns of the second input matrix", true);
        this.addOption("inputPathA", "ia", "Path to the first input matrix", true);
        this.addOption("inputPathB", "ib", "Path to the second input matrix", true);
        this.addOption("outputPath", "op", "Path to the output matrix", false);
        Map<String, List<String>> argMap = this.parseArguments(strings);
        if (argMap == null) {
            return -1;
        }
        DistributedRowMatrix a = new DistributedRowMatrix(new Path(this.getOption("inputPathA")), new Path(this.getOption("tempDir")), Integer.parseInt(this.getOption("numRowsA")), Integer.parseInt(this.getOption("numColsA")));
        DistributedRowMatrix b = new DistributedRowMatrix(new Path(this.getOption("inputPathB")), new Path(this.getOption("tempDir")), Integer.parseInt(this.getOption("numRowsB")), Integer.parseInt(this.getOption("numColsB")));
        a.setConf(new Configuration(this.getConf()));
        b.setConf(new Configuration(this.getConf()));
        if (this.hasOption("outputPath")) {
            a.times(b, new Path(this.getOption("outputPath")));
        } else {
            a.times(b);
        }
        return 0;
    }

    public static class MatrixMultiplicationReducer
    extends MapReduceBase
    implements Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        public void reduce(IntWritable rowNum, Iterator<VectorWritable> it, OutputCollector<IntWritable, VectorWritable> out, Reporter reporter) throws IOException {
            if (!it.hasNext()) {
                return;
            }
            RandomAccessSparseVector accumulator = new RandomAccessSparseVector(it.next().get());
            while (it.hasNext()) {
                Vector row = it.next().get();
                accumulator.assign(row, Functions.PLUS);
            }
            out.collect((Object)rowNum, (Object)new VectorWritable((Vector)new SequentialAccessSparseVector((Vector)accumulator)));
        }
    }

    public static class MatrixMultiplyMapper
    extends MapReduceBase
    implements Mapper<IntWritable, TupleWritable, IntWritable, VectorWritable> {
        private int outCardinality;
        private final IntWritable row = new IntWritable();

        public void configure(JobConf conf) {
            this.outCardinality = conf.getInt(MatrixMultiplicationJob.OUT_CARD, Integer.MAX_VALUE);
        }

        public void map(IntWritable index, TupleWritable v, OutputCollector<IntWritable, VectorWritable> out, Reporter reporter) throws IOException {
            boolean firstIsOutFrag = ((VectorWritable)v.get(0)).get().size() == this.outCardinality;
            Vector outFrag = firstIsOutFrag ? ((VectorWritable)v.get(0)).get() : ((VectorWritable)v.get(1)).get();
            Vector multiplier = firstIsOutFrag ? ((VectorWritable)v.get(1)).get() : ((VectorWritable)v.get(0)).get();
            VectorWritable outVector = new VectorWritable();
            for (Vector.Element e : multiplier.nonZeroes()) {
                this.row.set(e.index());
                outVector.set(outFrag.times(e.get()));
                out.collect((Object)this.row, (Object)outVector);
            }
        }
    }
}

