/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class VJob {
    private static final String OUTPUT_V = "v";
    private static final String PROP_UHAT_PATH = "ssvd.uhat.path";
    private static final String PROP_SIGMA_PATH = "ssvd.sigma.path";
    private static final String PROP_OUTPUT_SCALING = "ssvd.v.output.scaling";
    private static final String PROP_K = "ssvd.k";
    public static final String PROP_SQ_PATH = "ssvdpca.sq.path";
    public static final String PROP_XI_PATH = "ssvdpca.xi.path";
    private Job job;

    public void run(Configuration conf, Path inputPathBt, Path xiPath, Path sqPath, Path inputUHatPath, Path inputSigmaPath, Path outputPath, int k, int numReduceTasks, SSVDSolver.OutputScalingEnum outputScaling) throws ClassNotFoundException, InterruptedException, IOException {
        this.job = new Job(conf);
        this.job.setJobName("V-job");
        this.job.setJarByClass(VJob.class);
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{inputPathBt});
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
        this.job.getConfiguration().set("mapreduce.output.basename", OUTPUT_V);
        FileOutputFormat.setCompressOutput((Job)this.job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)this.job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)this.job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        this.job.setMapOutputKeyClass(IntWritable.class);
        this.job.setMapOutputValueClass(VectorWritable.class);
        this.job.setOutputKeyClass(IntWritable.class);
        this.job.setOutputValueClass(VectorWritable.class);
        this.job.setMapperClass(VMapper.class);
        this.job.getConfiguration().set(PROP_UHAT_PATH, inputUHatPath.toString());
        this.job.getConfiguration().set(PROP_SIGMA_PATH, inputSigmaPath.toString());
        this.job.getConfiguration().set(PROP_OUTPUT_SCALING, outputScaling.name());
        this.job.getConfiguration().setInt(PROP_K, k);
        this.job.setNumReduceTasks(0);
        if (xiPath != null) {
            this.job.getConfiguration().set(PROP_XI_PATH, xiPath.toString());
            this.job.getConfiguration().set(PROP_SQ_PATH, sqPath.toString());
        }
        this.job.submit();
    }

    public void waitForCompletion() throws IOException, ClassNotFoundException, InterruptedException {
        this.job.waitForCompletion(false);
        if (!this.job.isSuccessful()) {
            throw new IOException("V job unsuccessful.");
        }
    }

    public static final class VMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private Matrix uHat;
        private Vector vRow;
        private Vector sValues;
        private VectorWritable vRowWritable;
        private int kp;
        private int k;
        private Vector xi;
        private Vector sq;
        private final PlusMult plusMult = new PlusMult(0.0);

        protected void map(IntWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector bCol = value.get();
            if (this.xi != null) {
                int btIndex = key.get();
                double xii = this.xi.size() > btIndex ? this.xi.getQuick(btIndex) : 0.0;
                this.plusMult.setMultiplicator(-xii);
                bCol.assign(this.sq, (DoubleDoubleFunction)this.plusMult);
            }
            for (int i = 0; i < this.k; ++i) {
                this.vRow.setQuick(i, bCol.dot(this.uHat.viewColumn(i)) / this.sValues.getQuick(i));
            }
            context.write((Object)key, (Object)this.vRowWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path uHatPath = new Path(conf.get(VJob.PROP_UHAT_PATH));
            Path sigmaPath = new Path(conf.get(VJob.PROP_SIGMA_PATH));
            this.uHat = SSVDHelper.drmLoadAsDense(fs, uHatPath, conf);
            this.kp = this.uHat.columnSize();
            this.k = context.getConfiguration().getInt(VJob.PROP_K, this.kp);
            this.vRow = new DenseVector(this.k);
            this.vRowWritable = new VectorWritable(this.vRow);
            this.sValues = SSVDHelper.loadVector(sigmaPath, conf);
            SSVDSolver.OutputScalingEnum outputScaling = SSVDSolver.OutputScalingEnum.valueOf(context.getConfiguration().get(VJob.PROP_OUTPUT_SCALING));
            switch (outputScaling) {
                case SIGMA: {
                    this.sValues.assign(1.0);
                    break;
                }
                case HALFSIGMA: {
                    this.sValues = SSVDHelper.loadVector(sigmaPath, context.getConfiguration());
                    this.sValues.assign(Functions.SQRT);
                    break;
                }
            }
            String xiPathStr = conf.get(VJob.PROP_XI_PATH);
            if (xiPathStr != null) {
                this.xi = SSVDHelper.loadAndSumUpVectors(new Path(xiPathStr), conf);
                this.sq = SSVDHelper.loadAndSumUpVectors(new Path(conf.get(VJob.PROP_SQ_PATH)), conf);
            }
        }
    }
}

