/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.IntIntFunction;

class FunctionalMatrixView
extends AbstractMatrix {
    private IntIntFunction gf;
    private boolean denseLike;

    public FunctionalMatrixView(int rows, int columns, IntIntFunction gf) {
        this(rows, columns, gf, false);
    }

    public FunctionalMatrixView(int rows, int columns, IntIntFunction gf, boolean denseLike) {
        super(rows, columns);
        this.gf = gf;
        this.denseLike = denseLike;
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Assignment to a matrix not supported");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Assignment to a matrix view not supported");
    }

    @Override
    public double getQuick(int row, int column) {
        return this.gf.apply(row, column);
    }

    @Override
    public Matrix like() {
        return this.like(this.rows, this.columns);
    }

    @Override
    public Matrix like(int rows, int columns) {
        if (this.denseLike) {
            return new DenseMatrix(rows, columns);
        }
        return new SparseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        throw new UnsupportedOperationException("Assignment to a matrix view not supported");
    }
}

