/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.authentication;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseAuthenticationProvider
implements IAuthenticationProvider {
    private static final HashSet<String> validGraphHostNames = new HashSet<String>(Arrays.asList("graph.microsoft.com", "graph.microsoft.us", "dod-graph.microsoft.us", "graph.microsoft.de", "microsoftgraph.chinacloudapi.cn", "canary.graph.microsoft.com"));
    private HashSet<String> customHosts;

    public void setCustomHosts(@Nonnull String[] customHosts) {
        if (this.customHosts == null) {
            this.customHosts = new HashSet();
        }
        for (String host : customHosts) {
            this.customHosts.add(host.toLowerCase(Locale.ROOT));
        }
    }

    @Nullable
    public String[] getCustomHosts() {
        return this.customHosts.toArray(new String[this.customHosts.size()]);
    }

    protected boolean shouldAuthenticateRequestWithUrl(@Nonnull URL requestUrl) {
        if (requestUrl == null || !requestUrl.getProtocol().toLowerCase(Locale.ROOT).equals("https")) {
            return false;
        }
        String hostName = requestUrl.getHost().toLowerCase(Locale.ROOT);
        return this.customHosts == null ? validGraphHostNames.contains(hostName) : this.customHosts.contains(hostName);
    }
}

