/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane;

import uk.co.mmscomputing.device.sane.SaneConstants;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.gui.SaneSelectPanel;
import uk.co.mmscomputing.device.sane.jsane;

public class SaneDeviceManager
implements SaneConstants {
    private SaneDevice device = null;
    private String devicename = null;
    private boolean onlyLocal = true;

    SaneDeviceManager() {
    }

    public void setDevice(String string) {
        this.devicename = string;
    }

    public void setLocalOnly(boolean bl) {
        this.onlyLocal = bl;
    }

    public String[] getDevices() throws SaneIOException {
        return jsane.getDevices(this.onlyLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SaneDevice getDevice() throws SaneIOException {
        if (this.device != null && (this.device.isBusy() || this.device.getName().equals(this.devicename))) {
            return this.device;
        }
        if (this.devicename == null || this.devicename.equals("")) {
            jsane.init();
            try {
                String[] stringArray = this.getDevices();
                if (stringArray.length == 0) {
                    throw new SaneIOException(this.getClass(), "getDevice", "SaneDeviceManager.ex.nodevicesinstalled");
                }
                this.devicename = stringArray[0];
            }
            finally {
                jsane.exit();
            }
        }
        this.device = new SaneDevice(this.devicename);
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDevice() throws SaneIOException {
        jsane.init();
        try {
            String[] stringArray = jsane.getDevices(this.onlyLocal);
            new SaneSelectPanel(this, stringArray).showDialog();
        }
        finally {
            jsane.exit();
        }
    }

    void selectDevice(String string) throws SaneIOException {
        jsane.init();
        try {
            String[] stringArray = jsane.getDevices(this.onlyLocal);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.devicename = stringArray[i];
                return;
            }
            throw new SaneIOException(this.getClass(), "selectDevice", "SaneDeviceManager.ex.cannotfinddevice", string);
        }
        finally {
            jsane.exit();
        }
    }
}

