/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.scanner;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public abstract class Scanner {
    protected static boolean installed = false;
    protected Vector listeners = new Vector();
    protected ScannerIOMetadata metadata = null;
    protected boolean isbusy = false;

    public abstract boolean isAPIInstalled();

    public abstract void select() throws ScannerIOException;

    public abstract String[] getDeviceNames() throws ScannerIOException;

    public abstract void select(String var1) throws ScannerIOException;

    public abstract String getSelectedDeviceName() throws ScannerIOException;

    public abstract void acquire() throws ScannerIOException;

    public abstract void setCancel(boolean var1) throws ScannerIOException;

    public boolean isBusy() {
        return this.isbusy;
    }

    public void waitToExit() {
        try {
            while (this.isBusy()) {
                Thread.currentThread();
                Thread.sleep(200L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addListener(ScannerListener scannerListener) {
        this.listeners.add(scannerListener);
    }

    public void removeListener(ScannerListener scannerListener) {
        this.listeners.remove(scannerListener);
    }

    public void fireExceptionUpdate(Exception exception) {
        this.metadata.setException(exception);
        this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }

    public void fireListenerUpdate(ScannerIOMetadata.Type type) {
        if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            this.isbusy = this.metadata.getDevice().isBusy();
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ScannerListener scannerListener = (ScannerListener)enumeration.nextElement();
            scannerListener.update(type, this.metadata);
        }
    }

    public JComponent getScanGUI() throws ScannerIOException {
        return new JLabel("Dummy Scanner GUI");
    }

    public JComponent getScanGUI(int n) throws ScannerIOException {
        return new JLabel("Dummy Scanner GUI");
    }

    public static Scanner getDevice() {
        String string;
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Linux")) {
            string = "uk.co.mmscomputing.device.sane.SaneScanner";
        } else if (string2.startsWith("Windows")) {
            string = "uk.co.mmscomputing.device.twain.TwainScanner";
        } else {
            return null;
        }
        try {
            Scanner scanner = (Scanner)Class.forName(string).newInstance();
            if (scanner.isAPIInstalled()) {
                return scanner;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }
}

