/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.Hint;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.ProfilingTraceData;
import io.sentry.ScopeCallback;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.TraceContext;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.UserFeedback;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IHub {
    public boolean isEnabled();

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event) {
        return this.captureEvent(event, new Hint());
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @NotNull ScopeCallback callback) {
        return this.captureEvent(event, new Hint(), callback);
    }

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable Hint var2, @NotNull ScopeCallback var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message) {
        return this.captureMessage(message, SentryLevel.INFO);
    }

    @NotNull
    public SentryId captureMessage(@NotNull String var1, @NotNull SentryLevel var2);

    @NotNull
    public SentryId captureMessage(@NotNull String var1, @NotNull SentryLevel var2, @NotNull ScopeCallback var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull ScopeCallback callback) {
        return this.captureMessage(message, SentryLevel.INFO, callback);
    }

    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureEnvelope(@NotNull SentryEnvelope envelope) {
        return this.captureEnvelope(envelope, new Hint());
    }

    @NotNull
    public SentryId captureException(@NotNull Throwable var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable) {
        return this.captureException(throwable, new Hint());
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @NotNull ScopeCallback callback) {
        return this.captureException(throwable, new Hint(), callback);
    }

    @NotNull
    public SentryId captureException(@NotNull Throwable var1, @Nullable Hint var2, @NotNull ScopeCallback var3);

    public void captureUserFeedback(@NotNull UserFeedback var1);

    public void startSession();

    public void endSession();

    public void close();

    public void addBreadcrumb(@NotNull Breadcrumb var1, @Nullable Hint var2);

    default public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.addBreadcrumb(breadcrumb, new Hint());
    }

    default public void addBreadcrumb(@NotNull String message) {
        this.addBreadcrumb(new Breadcrumb(message));
    }

    default public void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Breadcrumb breadcrumb = new Breadcrumb(message);
        breadcrumb.setCategory(category);
        this.addBreadcrumb(breadcrumb);
    }

    public void setLevel(@Nullable SentryLevel var1);

    public void setTransaction(@Nullable String var1);

    public void setUser(@Nullable User var1);

    public void setFingerprint(@NotNull List<String> var1);

    public void clearBreadcrumbs();

    public void setTag(@NotNull String var1, @NotNull String var2);

    public void removeTag(@NotNull String var1);

    public void setExtra(@NotNull String var1, @NotNull String var2);

    public void removeExtra(@NotNull String var1);

    @NotNull
    public SentryId getLastEventId();

    public void pushScope();

    public void popScope();

    public void withScope(@NotNull ScopeCallback var1);

    public void configureScope(@NotNull ScopeCallback var1);

    public void bindClient(@NotNull ISentryClient var1);

    public void flush(long var1);

    @NotNull
    public IHub clone();

    @ApiStatus.Internal
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction var1, @Nullable TraceContext var2, @Nullable Hint var3, @Nullable ProfilingTraceData var4);

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Hint hint) {
        return this.captureTransaction(transaction, traceContext, hint, null);
    }

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable Hint hint) {
        return this.captureTransaction(transaction, null, hint);
    }

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext) {
        return this.captureTransaction(transaction, traceContext, null);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return this.startTransaction(transactionContexts, false);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull TransactionContext transactionContexts, boolean bindToScope) {
        return this.startTransaction(transactionContexts, null, bindToScope);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable CustomSamplingContext customSamplingContext) {
        return this.startTransaction(name, operation, customSamplingContext, false);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable CustomSamplingContext customSamplingContext, boolean bindToScope) {
        return this.startTransaction(new TransactionContext(name, operation), customSamplingContext, bindToScope);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull TransactionContext transactionContexts, @Nullable CustomSamplingContext customSamplingContext) {
        return this.startTransaction(transactionContexts, customSamplingContext, false);
    }

    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext var1, @Nullable CustomSamplingContext var2, boolean var3);

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation) {
        return this.startTransaction(name, operation, null);
    }

    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext var1, @NotNull TransactionOptions var2);

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation, boolean bindToScope) {
        return this.startTransaction(name, operation, null, bindToScope);
    }

    @Nullable
    public SentryTraceHeader traceHeaders();

    @ApiStatus.Internal
    public void setSpanContext(@NotNull Throwable var1, @NotNull ISpan var2, @NotNull String var3);

    @Nullable
    public ISpan getSpan();

    @NotNull
    public SentryOptions getOptions();

    @Nullable
    public Boolean isCrashedLastRun();

    public void reportFullyDisplayed();

    @Deprecated
    default public void reportFullDisplayed() {
        this.reportFullyDisplayed();
    }
}

