/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Baggage;
import io.sentry.BaggageHeader;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.MeasurementUnit;
import io.sentry.NoOpSpan;
import io.sentry.PerformanceCollectionData;
import io.sentry.ProfilingTraceData;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.TransactionFinishedCallback;
import io.sentry.TransactionOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.protocol.User;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryTracer
implements ITransaction {
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final Span root;
    @NotNull
    private final List<Span> children = new CopyOnWriteArrayList<Span>();
    @NotNull
    private final IHub hub;
    @NotNull
    private String name;
    @NotNull
    private FinishStatus finishStatus = FinishStatus.NOT_FINISHED;
    @Nullable
    private final TransactionFinishedCallback transactionFinishedCallback;
    @Nullable
    private volatile TimerTask timerTask;
    @Nullable
    private volatile Timer timer = null;
    @NotNull
    private final Object timerLock = new Object();
    @NotNull
    private final AtomicBoolean isFinishTimerRunning = new AtomicBoolean(false);
    @NotNull
    private final Baggage baggage;
    @NotNull
    private TransactionNameSource transactionNameSource;
    @NotNull
    private final Map<String, MeasurementValue> measurements;
    @NotNull
    private final Instrumenter instrumenter;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private final TransactionPerformanceCollector transactionPerformanceCollector;
    @NotNull
    private final TransactionOptions transactionOptions;

    public SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub) {
        this(context, hub, new TransactionOptions(), null, null);
    }

    public SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub, @NotNull TransactionOptions transactionOptions, @Nullable TransactionFinishedCallback transactionFinishedCallback) {
        this(context, hub, transactionOptions, transactionFinishedCallback, null);
    }

    SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub, @NotNull TransactionOptions transactionOptions, @Nullable TransactionFinishedCallback transactionFinishedCallback, @Nullable TransactionPerformanceCollector transactionPerformanceCollector) {
        Objects.requireNonNull(context, "context is required");
        Objects.requireNonNull(hub, "hub is required");
        this.measurements = new ConcurrentHashMap<String, MeasurementValue>();
        this.root = new Span(context, this, hub, transactionOptions.getStartTimestamp(), transactionOptions);
        this.name = context.getName();
        this.instrumenter = context.getInstrumenter();
        this.hub = hub;
        this.transactionFinishedCallback = transactionFinishedCallback;
        this.transactionPerformanceCollector = transactionPerformanceCollector;
        this.transactionNameSource = context.getTransactionNameSource();
        this.transactionOptions = transactionOptions;
        this.baggage = context.getBaggage() != null ? context.getBaggage() : new Baggage(hub.getOptions().getLogger());
        if (transactionPerformanceCollector != null && Boolean.TRUE.equals(this.isProfileSampled())) {
            transactionPerformanceCollector.start(this);
        }
        if (transactionOptions.getIdleTimeout() != null) {
            this.timer = new Timer(true);
            this.scheduleFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleFinish() {
        Object object = this.timerLock;
        synchronized (object) {
            this.cancelTimer();
            if (this.timer != null) {
                this.isFinishTimerRunning.set(true);
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        SentryTracer.this.finishFromTimer();
                    }
                };
                try {
                    this.timer.schedule(this.timerTask, this.transactionOptions.getIdleTimeout());
                }
                catch (Throwable e) {
                    this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to schedule finish timer", e);
                    this.finishFromTimer();
                }
            }
        }
    }

    private void finishFromTimer() {
        SpanStatus status = this.getStatus();
        this.finish(status != null ? status : SpanStatus.OK);
        this.isFinishTimerRunning.set(false);
    }

    @Override
    @NotNull
    public void forceFinish(@NotNull SpanStatus status, boolean dropIfNoChildren) {
        if (this.isFinished()) {
            return;
        }
        @NotNull SentryDate finishTimestamp = this.hub.getOptions().getDateProvider().now();
        @NotNull ListIterator<Span> iterator = this.children.listIterator(this.children.size());
        while (iterator.hasPrevious()) {
            @NotNull Span span = iterator.previous();
            span.setSpanFinishedCallback(null);
            span.finish(status, finishTimestamp);
        }
        this.finish(status, finishTimestamp, dropIfNoChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@Nullable SpanStatus status, @Nullable SentryDate finishDate, boolean dropIfNoChildren) {
        SentryDate finishTimestamp = this.root.getFinishDate();
        if (finishDate != null) {
            finishTimestamp = finishDate;
        }
        if (finishTimestamp == null) {
            finishTimestamp = this.hub.getOptions().getDateProvider().now();
        }
        for (Span span : this.children) {
            if (!span.getOptions().isIdle()) continue;
            span.finish(status != null ? status : this.getSpanContext().status, finishTimestamp);
        }
        this.finishStatus = FinishStatus.finishing(status);
        if (!(this.root.isFinished() || this.transactionOptions.isWaitForChildren() && !this.hasAllChildrenFinished())) {
            List<PerformanceCollectionData> performanceCollectionData = null;
            if (this.transactionPerformanceCollector != null) {
                performanceCollectionData = this.transactionPerformanceCollector.stop(this);
            }
            ProfilingTraceData profilingTraceData = null;
            if (Boolean.TRUE.equals(this.isSampled()) && Boolean.TRUE.equals(this.isProfileSampled())) {
                profilingTraceData = this.hub.getOptions().getTransactionProfiler().onTransactionFinish(this, performanceCollectionData);
            }
            if (performanceCollectionData != null) {
                performanceCollectionData.clear();
            }
            for (Span child : this.children) {
                if (child.isFinished()) continue;
                child.setSpanFinishedCallback(null);
                child.finish(SpanStatus.DEADLINE_EXCEEDED, finishTimestamp);
            }
            this.root.finish(this.finishStatus.spanStatus, finishTimestamp);
            this.hub.configureScope(scope -> scope.withTransaction(transaction -> {
                if (transaction == this) {
                    scope.clearTransaction();
                }
            }));
            SentryTransaction transaction = new SentryTransaction(this);
            if (this.transactionFinishedCallback != null) {
                this.transactionFinishedCallback.execute(this);
            }
            if (this.timer != null) {
                Object object = this.timerLock;
                synchronized (object) {
                    if (this.timer != null) {
                        this.timer.cancel();
                        this.timer = null;
                    }
                }
            }
            if (dropIfNoChildren && this.children.isEmpty() && this.transactionOptions.getIdleTimeout() != null) {
                this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Dropping idle transaction %s because it has no child spans", this.name);
                return;
            }
            transaction.getMeasurements().putAll(this.measurements);
            this.hub.captureTransaction(transaction, this.traceContext(), null, profilingTraceData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.isFinishTimerRunning.set(false);
                this.timerTask = null;
            }
        }
    }

    @NotNull
    public List<Span> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public SentryDate getStartDate() {
        return this.root.getStartDate();
    }

    @Override
    @Nullable
    public SentryDate getFinishDate() {
        return this.root.getFinishDate();
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description) {
        return this.startChild(parentSpanId, operation, description, new SpanOptions());
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @NotNull SpanOptions spanOptions) {
        return this.createChild(parentSpanId, operation, description, spanOptions);
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter) {
        return this.createChild(parentSpanId, operation, description, timestamp, instrumenter, new SpanOptions());
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        return this.createChild(parentSpanId, operation, description, timestamp, instrumenter, spanOptions);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @NotNull SpanOptions options) {
        return this.createChild(parentSpanId, operation, description, null, Instrumenter.SENTRY, options);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (!this.instrumenter.equals((Object)instrumenter)) {
            return NoOpSpan.getInstance();
        }
        Objects.requireNonNull(parentSpanId, "parentSpanId is required");
        Objects.requireNonNull(operation, "operation is required");
        this.cancelTimer();
        Span span = new Span(this.root.getTraceId(), parentSpanId, this, operation, this.hub, timestamp, spanOptions, __ -> {
            FinishStatus finishStatus = this.finishStatus;
            if (this.transactionOptions.getIdleTimeout() != null) {
                if (!this.transactionOptions.isWaitForChildren() || this.hasAllChildrenFinished()) {
                    this.scheduleFinish();
                }
            } else if (finishStatus.isFinishing) {
                this.finish(finishStatus.spanStatus);
            }
        });
        span.setDescription(description);
        this.children.add(span);
        return span;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter) {
        return this.startChild(operation, description, timestamp, instrumenter, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        return this.createChild(operation, description, timestamp, instrumenter, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp) {
        return this.createChild(operation, description, timestamp, Instrumenter.SENTRY, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.startChild(operation, description, null, Instrumenter.SENTRY, new SpanOptions());
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @NotNull SpanOptions spanOptions) {
        return this.createChild(operation, description, null, Instrumenter.SENTRY, spanOptions);
    }

    @NotNull
    private ISpan createChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (!this.instrumenter.equals((Object)instrumenter)) {
            return NoOpSpan.getInstance();
        }
        if (this.children.size() < this.hub.getOptions().getMaxSpans()) {
            return this.root.startChild(operation, description, timestamp, instrumenter, spanOptions);
        }
        this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description);
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.root.toSentryTrace();
    }

    @Override
    public void finish() {
        this.finish(this.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.finish(status, null);
    }

    @Override
    @ApiStatus.Internal
    public void finish(@Nullable SpanStatus status, @Nullable SentryDate finishDate) {
        this.finish(status, finishDate, true);
    }

    @Override
    @Nullable
    public TraceContext traceContext() {
        if (this.hub.getOptions().isTraceSampling()) {
            this.updateBaggageValues();
            return this.baggage.toTraceContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBaggageValues() {
        SentryTracer sentryTracer = this;
        synchronized (sentryTracer) {
            if (this.baggage.isMutable()) {
                AtomicReference userAtomicReference = new AtomicReference();
                this.hub.configureScope(scope -> userAtomicReference.set(scope.getUser()));
                this.baggage.setValuesFromTransaction(this, (User)userAtomicReference.get(), this.hub.getOptions(), this.getSamplingDecision());
                this.baggage.freeze();
            }
        }
    }

    @Override
    @Nullable
    public BaggageHeader toBaggageHeader(@Nullable List<String> thirdPartyBaggageHeaders) {
        if (this.hub.getOptions().isTraceSampling()) {
            this.updateBaggageValues();
            return BaggageHeader.fromBaggageAndOutgoingHeader(this.baggage, thirdPartyBaggageHeaders);
        }
        return null;
    }

    private boolean hasAllChildrenFinished() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (Span span : spans) {
                if (span.isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.root.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.root.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.root.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.root.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.root.getSpanContext();
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.root.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.root.isFinished();
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setData(key, value);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return this.root.getData(key);
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value) {
        if (this.root.isFinished()) {
            return;
        }
        this.measurements.put(name, new MeasurementValue(value, null));
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value, @NotNull MeasurementUnit unit) {
        if (this.root.isFinished()) {
            return;
        }
        this.measurements.put(name, new MeasurementValue(value, unit.apiName()));
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.root.getData();
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.root.isSampled();
    }

    @Override
    @Nullable
    public Boolean isProfileSampled() {
        return this.root.isProfileSampled();
    }

    @Override
    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.root.getSamplingDecision();
    }

    @Override
    public void setName(@NotNull String name) {
        this.setName(name, TransactionNameSource.CUSTOM);
    }

    @Override
    @ApiStatus.Internal
    public void setName(@NotNull String name, @NotNull TransactionNameSource transactionNameSource) {
        if (this.root.isFinished()) {
            return;
        }
        this.name = name;
        this.transactionNameSource = transactionNameSource;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public TransactionNameSource getTransactionNameSource() {
        return this.transactionNameSource;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return this.children;
    }

    @Override
    @Nullable
    public Span getLatestActiveSpan() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (int i = spans.size() - 1; i >= 0; --i) {
                if (((Span)spans.get(i)).isFinished()) continue;
                return (Span)spans.get(i);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return this.eventId;
    }

    @NotNull
    Span getRoot() {
        return this.root;
    }

    @TestOnly
    @Nullable
    TimerTask getTimerTask() {
        return this.timerTask;
    }

    @TestOnly
    @Nullable
    Timer getTimer() {
        return this.timer;
    }

    @TestOnly
    @NotNull
    AtomicBoolean isFinishTimerRunning() {
        return this.isFinishTimerRunning;
    }

    @TestOnly
    @NotNull
    Map<String, MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    @ApiStatus.Internal
    public void setContext(@NotNull String key, @NotNull Object context) {
        this.contexts.put(key, context);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Override
    public boolean updateEndDate(@NotNull SentryDate date) {
        return this.root.updateEndDate(date);
    }

    @Override
    public boolean isNoOp() {
        return false;
    }

    private static final class FinishStatus {
        static final FinishStatus NOT_FINISHED = FinishStatus.notFinished();
        private final boolean isFinishing;
        @Nullable
        private final SpanStatus spanStatus;

        @NotNull
        static FinishStatus finishing(@Nullable SpanStatus finishStatus) {
            return new FinishStatus(true, finishStatus);
        }

        @NotNull
        private static FinishStatus notFinished() {
            return new FinishStatus(false, null);
        }

        private FinishStatus(boolean isFinishing, @Nullable SpanStatus spanStatus) {
            this.isFinishing = isFinishing;
            this.spanStatus = spanStatus;
        }
    }
}

