/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.atlanticbb.tantlinger.io.CopyMonitor;

public class MonitoredInputStream
extends FilterInputStream {
    CopyMonitor monitor;

    public MonitoredInputStream(InputStream in, CopyMonitor monitor) {
        super(in);
        this.monitor = monitor;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        this.checkAborted();
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAborted();
        int numRead = super.read(b, off, len);
        if (numRead != -1) {
            this.monitor.bytesCopied(numRead);
        }
        return numRead;
    }

    public int read(byte[] b) throws IOException {
        this.checkAborted();
        return super.read(b);
    }

    private void checkAborted() throws IOException {
        if (this.monitor.isCopyAborted()) {
            System.err.println("copy aborted");
            throw new IOException("Copy aborted");
        }
    }
}

