/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.print.Paper;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.print.EditorPanePrinter;
import net.atlanticbb.tantlinger.print.PreviewDialog;

public class PrintApp
extends JFrame {
    public static String htmlString = "<html>\n<head>\n</head>\n\n<body>\n<h1>Press F2 to see Print Preview of the HTML page.</h1>\n<p>This HTML content example was written to provide print preview and print of any JEditorPane/JTextPane content no matter what EditorKit is set.</p>\n<p>To illustrate the feature HTMLEditorKit was used.</p>\n<h2>Repeating content to fill the page and show how table is separated between pages.</h2>\n<p>This HTML content example was written to provide print preview and print of any JEditorPane/JTextPane content no matter what EditorKit is set.</p>\n<p>To illustrate the feature HTMLEditorKit was used.</p>\n<h2>Repeating content to fill the page and show how table is separated between pages.</h2>\n<p>This HTML content example was written to provide print preview and print of any JEditorPane/JTextPane content no matter what EditorKit is set.</p>\n<p>To illustrate the feature HTMLEditorKit was used.</p>\n<h2>Repeating content to fill the page and show how table is separated between pages.</h2>\n<p>This HTML content example was written to provide print preview and print of any JEditorPane/JTextPane content no matter what EditorKit is set.</p>\n<table cellspacing=\"0\" border=\"1\" width=\"70%\" cellpadding=\"3\">\n<tr>\n<th>\n<p>Monday <input type='submit' value='Button'> <input value='TextField'> </p>\n</th>\n<th>\n<p>Tuesday</p>\n</th>\n<th>\n<p>Wednesday</p>\n</th>\n</tr>\n<tr>\n<td width=\"70%\">\n<p>Row 1, Cell 1 </p>\n <table align=\"left\">\n  <tr><td>inner 1:1</td><td>inner 1:2</td></tr>\n  <tr><td>inner 2:1</td><td>inner 2:2</td></tr>\n </table>\n<p>Inner table cell's paragraph must be very long to illustrate text flow and multiple lines filling.</p>\n</td>\n<td>\n<p><font size=\"+1\">Row 1, Cell 2</p></font>\n</td>\n<td>\n<p>Row 1, Cell 3</p>\n<p>Row 1, Cell 3</p>\n<p>Row 1, Cell 3</p>\n<p>Row 1, Cell 3</p>\n</td>\n</tr>\n<tr>\n<td>\n<p>Row 2, Cell 1</p>\n</td>\n<td>\n<p>Row 2, Cell 2</p>\n</td>\n<td>\n<p>Row 2, Cell 3</p>\n</td>\n</tr>\n</table>\n<h2>The text after table</h2>\n<p>An additional text to surround table with content.</p>\n<p>&nbsp;</p>\n\n</body>\n</html>";
    Shape viewShape;
    JEditorPane editor = new JEditorPane();
    JTextArea editorSource = new JTextArea();
    JButton btnPreview = new JButton("Print Preview");
    JButton btnPrint = new JButton("Print");
    JButton btnApply = new JButton("Show changed sources");
    JTabbedPane tab = new JTabbedPane();

    public static void main(String[] args) {
        PrintApp app = new PrintApp();
        app.setVisible(true);
    }

    public PrintApp() {
        super("Printer example");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.tab, "North");
        JPanel pnlButtons = new JPanel(new FlowLayout());
        pnlButtons.add(this.btnPrint);
        pnlButtons.add(this.btnPreview);
        pnlButtons.add(this.btnApply);
        this.getContentPane().add((Component)pnlButtons, "South");
        HTMLEditorKit kit = new HTMLEditorKit();
        this.editor.setEditorKit(kit);
        this.editor.setContentType("text/html");
        this.editor.setText(htmlString);
        this.editor.setEditable(false);
        this.editorSource.setText(htmlString);
        JScrollPane scroll = new JScrollPane(this.editor);
        this.tab.add("HTML", scroll);
        scroll = new JScrollPane(this.editorSource);
        this.tab.add("Source", scroll);
        this.getContentPane().add((Component)this.tab, "Center");
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(5, 5, 5, 5));
        this.initKeyStrokes();
        this.setSize(750, 750);
        this.setLocationRelativeTo(null);
    }

    private void initKeyStrokes() {
        InputMap im = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap am = ((JComponent)this.getContentPane()).getActionMap();
        im.put(KeyStroke.getKeyStroke(113, 0), "preview");
        AbstractAction lst = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PreviewDialog dlg = new PreviewDialog(PrintApp.this, PrintApp.this.editor);
                dlg.setVisible(true);
            }
        };
        this.btnPreview.addActionListener(lst);
        am.put("preview", lst);
        lst = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EditorPanePrinter pnl = new EditorPanePrinter(PrintApp.this.editor, new Paper(), new Insets(18, 18, 18, 18));
                pnl.print();
            }
        };
        this.btnPrint.addActionListener(lst);
        lst = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                htmlString = PrintApp.this.editorSource.getText();
                PrintApp.this.editor.setText(htmlString);
                PrintApp.this.tab.setSelectedIndex(0);
            }
        };
        this.btnApply.addActionListener(lst);
    }

    protected static Shape getAllocation(View v, JEditorPane edit) {
        Insets ins = edit.getInsets();
        View root = edit.getUI().getRootView(edit);
        int x = ins.left;
        int y = ins.top;
        for (View vParent = v.getParent(); vParent != null; vParent = vParent.getParent()) {
            int i = vParent.getViewIndex(v.getStartOffset(), Position.Bias.Forward);
            Shape alloc = vParent.getChildAllocation(i, new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE));
            x += alloc.getBounds().x;
            y += alloc.getBounds().y;
        }
        return new Rectangle(x, y, (int)v.getPreferredSpan(0), (int)v.getPreferredSpan(1));
    }

    public int getOffset(BoxView source, int axis, int childIndex) {
        try {
            Method m = BoxView.class.getDeclaredMethod("getOffset", Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            return ((Number)m.invoke((Object)source, axis, childIndex)).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public short getLeftInset(CompositeView source) {
        try {
            Method m = CompositeView.class.getDeclaredMethod("getLeftInset", new Class[0]);
            m.setAccessible(true);
            return ((Number)m.invoke((Object)source, new Object[0])).shortValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public short getTopInset(CompositeView source) {
        try {
            Method m = CompositeView.class.getDeclaredMethod("getTopInset", new Class[0]);
            m.setAccessible(true);
            return ((Number)m.invoke((Object)source, new Object[0])).shortValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

