/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.atlanticbb.tantlinger.i18n.I18n;

public class ExceptionDialog
extends JDialog {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui");
    private static final long serialVersionUID = 1L;
    private static final int PREFERRED_WIDTH = 450;
    private static final String DEFAULT_TITLE = i18n.str("error");
    private JPanel jContentPane = null;
    private JLabel iconLabel = null;
    private JLabel titleLabel = null;
    private JLabel msgLabel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton detailsButton = null;
    private JScrollPane scrollPane = null;
    private JTextArea textArea = null;
    private JSeparator separator = null;

    public ExceptionDialog() {
        this.init(new Exception());
    }

    public ExceptionDialog(Frame owner, Throwable th) {
        super(owner, DEFAULT_TITLE);
        this.init(th);
    }

    public ExceptionDialog(Dialog owner, Throwable th) {
        super(owner, DEFAULT_TITLE);
        this.init(th);
    }

    private void init(Throwable th) {
        this.setModal(true);
        this.initialize();
        this.setThrowable(th);
        this.showDetails(false);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getOkButton());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 4;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridwidth = 3;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints11.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridheight = 3;
            gridBagConstraints3.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 20, 5, 5);
            gridBagConstraints2.gridy = 1;
            this.msgLabel = new JLabel();
            this.msgLabel.setText("");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 0;
            this.titleLabel = new JLabel();
            this.titleLabel.setText(i18n.str("error_prompt"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.iconLabel = new JLabel();
            this.iconLabel.setText("");
            this.iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(12, 5, 10, 5));
            this.jContentPane.add((Component)this.iconLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.titleLabel, gridBagConstraints1);
            this.jContentPane.add((Component)this.msgLabel, gridBagConstraints2);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getSeparator(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(0);
            gridLayout.setVgap(5);
            gridLayout.setColumns(1);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getDetailsButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(i18n.str("ok"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setText(i18n.str("_details"));
            this.detailsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.this.toggleDetails();
                }
            });
        }
        return this.detailsButton;
    }

    private void toggleDetails() {
        this.showDetails(!this.isDetailsVisible());
    }

    public void showDetails(boolean b) {
        if (b) {
            this.detailsButton.setText(i18n.str("details_"));
            this.scrollPane.setVisible(true);
            this.separator.setVisible(false);
        } else {
            this.detailsButton.setText(i18n.str("_details"));
            this.scrollPane.setVisible(false);
            this.separator.setVisible(true);
        }
        this.setResizable(true);
        this.pack();
        this.setResizable(false);
    }

    public boolean isDetailsVisible() {
        return this.scrollPane.isVisible();
    }

    public void setThrowable(Throwable th) {
        String msg = i18n.str("no_message_given");
        if (th.getLocalizedMessage() != null && !th.getLocalizedMessage().equals("")) {
            msg = th.getLocalizedMessage();
        }
        this.msgLabel.setText(msg);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(bout));
        String stackTrace = new String(bout.toByteArray());
        this.textArea.setText(stackTrace);
        this.textArea.setCaretPosition(0);
    }

    private JSeparator getSeparator() {
        if (this.separator == null) {
            this.separator = new JSeparator();
            this.separator.setPreferredSize(new Dimension(450, 3));
        }
        return this.separator;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(new Dimension(450, 200));
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setTabSize(2);
            this.textArea.setEditable(false);
            this.textArea.setOpaque(false);
        }
        return this.textArea;
    }
}

