/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.atlanticbb.tantlinger.ui.ExceptionDialog;
import org.bushe.swing.action.ActionUIFactory;

public class UIUtils {
    public static final String X16 = "resources/images/x16/";
    public static final String X24 = "resources/images/x24/";
    public static final String X32 = "resources/images/x32/";
    public static final String X48 = "resources/images/x32/";
    public static final String MISC = "resources/images/misc/";

    public static ImageIcon getIcon(String _package, String iconName) {
        if (!_package.endsWith("/")) {
            _package = _package + "/";
        }
        return UIUtils.getIcon(_package + iconName);
    }

    public static ImageIcon getIcon(String path) {
        return UIUtils.createImageIcon(path);
    }

    public static ImageIcon createImageIcon(String path) {
        URL u = Thread.currentThread().getContextClassLoader().getResource(path);
        if (u == null) {
            return null;
        }
        return new ImageIcon(u);
    }

    public static void showError(String msg) {
        UIUtils.showError(null, msg);
    }

    public static void showError(Component c, Throwable ex) {
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w instanceof Frame) {
            UIUtils.showError((Frame)w, ex);
        } else if (w instanceof Dialog) {
            UIUtils.showError((Dialog)w, ex);
        } else {
            UIUtils.showError(c, ex.getLocalizedMessage());
        }
    }

    public static void showError(Component owner, String msg) {
        UIUtils.showError(owner, "Error", msg);
    }

    public static void showError(Component owner, String title, String msg) {
        JOptionPane.showMessageDialog(owner, msg, title, 0);
    }

    public static void showError(Frame owner, String title, Throwable th) {
        ExceptionDialog d = new ExceptionDialog(owner, th);
        if (title != null) {
            d.setTitle(title);
        }
        d.setLocationRelativeTo(owner);
        d.setVisible(true);
        th.printStackTrace();
    }

    public static void showError(Frame owner, Throwable th) {
        UIUtils.showError(owner, null, th);
    }

    public static void showError(Dialog owner, String title, Throwable th) {
        ExceptionDialog d = new ExceptionDialog(owner, th);
        if (title != null) {
            d.setTitle(title);
        }
        d.setLocationRelativeTo(owner);
        d.setVisible(true);
        th.printStackTrace();
    }

    public static void showError(Dialog owner, Throwable th) {
        UIUtils.showError(owner, null, th);
    }

    public static void showWarning(Component owner, String title, String msg) {
        JOptionPane.showMessageDialog(owner, msg, title, 2);
    }

    public static void showWarning(Component owner, String msg) {
        UIUtils.showWarning(owner, "Warning", msg);
    }

    public static void showWarning(String msg) {
        UIUtils.showWarning(null, msg);
    }

    public static void showInfo(Component owner, String title, String msg) {
        JOptionPane.showMessageDialog(owner, msg, title, 1);
    }

    public static void showInfo(Component owner, String msg) {
        UIUtils.showInfo(owner, "Information", msg);
    }

    public static void showInfo(String msg) {
        UIUtils.showInfo(null, msg);
    }

    public static AbstractButton addToolBarButton(JToolBar tb, Action a) {
        return UIUtils.addToolBarButton(tb, ActionUIFactory.getInstance().createButton(a));
    }

    public static AbstractButton addToolBarButton(JToolBar tb, Action a, boolean focusable, boolean showIconOnly) {
        return UIUtils.addToolBarButton(tb, ActionUIFactory.getInstance().createButton(a), false, true);
    }

    public static AbstractButton addToolBarButton(JToolBar tb, AbstractButton button) {
        return UIUtils.addToolBarButton(tb, button, false, true);
    }

    public static AbstractButton addToolBarButton(JToolBar tb, AbstractButton button, boolean focusable, boolean showIconOnly) {
        Icon ico;
        if (button.getAction() != null) {
            button.setToolTipText((String)button.getAction().getValue("Name"));
            if (button.getAction().getValue("LARGE_ICON") != null) {
                try {
                    button.setIcon((Icon)button.getAction().getValue("LARGE_ICON"));
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
        }
        if ((ico = button.getIcon()) != null && showIconOnly) {
            button.setText(null);
            button.setMnemonic(0);
            button.putClientProperty("hideActionText", Boolean.TRUE);
            int square = Math.max(ico.getIconWidth(), ico.getIconHeight()) + 6;
            Dimension size = new Dimension(square, square);
            button.setPreferredSize(size);
        }
        if (!focusable) {
            button.setFocusable(false);
            button.setFocusPainted(false);
        }
        button.setMargin(new Insets(1, 1, 1, 1));
        tb.add(button);
        return button;
    }

    public static JMenuItem addMenuItem(JMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        UIUtils.configureMenuItem(item, action);
        return item;
    }

    public static JMenuItem addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        UIUtils.configureMenuItem(item, action);
        return item;
    }

    private static void configureMenuItem(JMenuItem item, Action action) {
        KeyStroke keystroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keystroke != null) {
            item.setAccelerator(keystroke);
        }
        item.setIcon(null);
        item.setToolTipText(null);
    }
}

