/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ImageView;

public class CachedImageView
extends ImageView {
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String PROP_DIR = USER_HOME + File.separator + ".thinga";
    public static final String IMG_CACHE_DIR = PROP_DIR + File.separator + "img_cache";
    private boolean hasCached;

    public CachedImageView(Element elem) {
        super(elem);
    }

    public void paint(Graphics g, Shape a) {
        boolean done;
        super.paint(g, a);
        Image img = this.getImage();
        int flags = Toolkit.getDefaultToolkit().checkImage(img, -1, -1, this.getContainer());
        boolean bl = done = (flags & 0x20) != 0;
        if (done && !this.hasCached) {
            this.cacheImage(img);
        }
    }

    private void cacheImage(final Image image) {
        final File cImg = this.getCachedImg();
        if (image == null || cImg == null || cImg.exists()) {
            return;
        }
        this.hasCached = true;
        Runnable runner = new Runnable(){

            public void run() {
                String type = "png";
                if (cImg.getAbsolutePath().endsWith("jpg")) {
                    type = "jpg";
                }
                BufferedImage bufImg = CachedImageView.this.makeBufferedImage(image);
                try {
                    ImageIO.write((RenderedImage)bufImg, type, cImg);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread th = new Thread(runner, "Image Cacher");
        th.setPriority(5);
        th.start();
    }

    private String srcAttribute() {
        return (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
    }

    public URL getImageURL() {
        String src = this.srcAttribute();
        if (src == null) {
            return null;
        }
        URL imgURL = null;
        File diskCachedImg = this.getCachedImg();
        try {
            if (diskCachedImg.exists()) {
                imgURL = diskCachedImg.toURL();
            } else {
                URL reference = ((HTMLDocument)this.getDocument()).getBase();
                imgURL = new URL(reference, src);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return imgURL;
    }

    private BufferedImage makeBufferedImage(Image image) {
        BufferedImage buffered = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = buffered.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return buffered;
    }

    private File getCachedImg() {
        String iUrl = this.srcAttribute();
        if (iUrl == null) {
            return null;
        }
        String imgType = ".png";
        if (iUrl.toLowerCase().endsWith(".jpg") || iUrl.toLowerCase().endsWith(".jpeg")) {
            imgType = ".jpg";
        }
        int hc = Math.abs(iUrl.hashCode());
        File cacheImg = new File(IMG_CACHE_DIR, hc + imgType);
        return cacheImg;
    }
}

