/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;

public class CompoundUndoManager
implements UndoableEditListener {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text");
    public static Action UNDO = new UndoAction();
    public static Action REDO = new RedoAction();
    private UndoManager undoer;
    private CompoundEdit compoundEdit = null;
    private Document document = null;
    private static Vector docs = new Vector();
    private static Vector lsts = new Vector();
    private static Vector undoers = new Vector();

    protected static void registerDocument(Document doc, CompoundUndoManager lst, UndoManager um) {
        docs.add(doc);
        lsts.add(lst);
        undoers.add(um);
    }

    public static UndoManager getUndoManagerForDocument(Document doc) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != doc) continue;
            return (UndoManager)undoers.elementAt(i);
        }
        return null;
    }

    public static void beginCompoundEdit(Document doc) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != doc) continue;
            CompoundUndoManager l = (CompoundUndoManager)lsts.elementAt(i);
            l.beginCompoundEdit();
            return;
        }
    }

    public static void endCompoundEdit(Document doc) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != doc) continue;
            CompoundUndoManager l = (CompoundUndoManager)lsts.elementAt(i);
            l.endCompoundEdit();
            return;
        }
    }

    public static void updateUndo(Document doc) {
        UndoManager um = CompoundUndoManager.getUndoManagerForDocument(doc);
        if (um != null) {
            UNDO.setEnabled(um.canUndo());
            REDO.setEnabled(um.canRedo());
        }
    }

    public static void discardAllEdits(Document doc) {
        UndoManager um = CompoundUndoManager.getUndoManagerForDocument(doc);
        if (um != null) {
            um.discardAllEdits();
            UNDO.setEnabled(um.canUndo());
            REDO.setEnabled(um.canRedo());
        }
    }

    public CompoundUndoManager(Document doc, UndoManager um) {
        this.undoer = um;
        this.document = doc;
        CompoundUndoManager.registerDocument(this.document, this, this.undoer);
    }

    public CompoundUndoManager(Document doc) {
        this(doc, new UndoManager());
    }

    public void undoableEditHappened(UndoableEditEvent evt) {
        UndoableEdit edit = evt.getEdit();
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(edit);
        } else {
            this.undoer.addEdit(edit);
            CompoundUndoManager.updateUndo(this.document);
        }
    }

    protected void beginCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    protected void endCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoer.addEdit(this.compoundEdit);
            CompoundUndoManager.updateUndo(this.document);
        }
        this.compoundEdit = null;
    }

    static class RedoAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super(i18n.str("redo"));
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "redo.png"));
            this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "redo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("redo")));
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        public void actionPerformed(ActionEvent e) {
            Document doc = this.getTextComponent(e).getDocument();
            UndoManager um = CompoundUndoManager.getUndoManagerForDocument(doc);
            if (um != null) {
                try {
                    um.redo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
                CompoundUndoManager.updateUndo(doc);
            }
        }
    }

    static class UndoAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super(i18n.str("undo"));
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "undo.png"));
            this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "undo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("undo")));
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        public void actionPerformed(ActionEvent e) {
            Document doc = this.getTextComponent(e).getDocument();
            UndoManager um = CompoundUndoManager.getUndoManagerForDocument(doc);
            if (um != null) {
                try {
                    um.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
                CompoundUndoManager.updateUndo(doc);
            }
        }
    }
}

