/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class IndentationFilter
extends DocumentFilter {
    private boolean isSoftTabs;
    private boolean isAutoIndent;

    public IndentationFilter() {
        this(false, true);
    }

    public IndentationFilter(boolean isSoftTabs, boolean isAutoIndent) {
        this.isSoftTabs = isSoftTabs;
        this.isAutoIndent = isAutoIndent;
    }

    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        if (text != null && length == 0) {
            if (this.isSoftTabs) {
                text = this.convertTabsToSpaces(text, doc);
            }
            if (this.isAutoIndent && text.startsWith("\n")) {
                text = text + this.getLineIndentation(offset, doc);
            }
        }
        super.replace(fb, offset, length, text, attrs);
    }

    private String convertTabsToSpaces(String text, Document doc) {
        try {
            AbstractDocument adoc = (AbstractDocument)doc;
            int tabSize = (Integer)adoc.getProperty("tabSize");
            String softTab = "";
            for (int i = 1; i <= tabSize; ++i) {
                softTab = softTab + ' ';
            }
            StringBuffer sb = new StringBuffer(text);
            int pos = 0;
            while ((pos = sb.indexOf("\t", pos)) != -1) {
                sb.replace(pos, pos + 1, softTab);
                pos += softTab.length();
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return text;
        }
    }

    private String getLineIndentation(int offs, Document doc) throws BadLocationException {
        StringBuffer ws = new StringBuffer();
        if (doc instanceof AbstractDocument) {
            char c;
            AbstractDocument adoc = (AbstractDocument)doc;
            int s = adoc.getParagraphElement(offs).getStartOffset();
            String line = adoc.getText(s, offs - s);
            for (int i = 0; i < line.length() && (c = line.charAt(i)) != '\n' && Character.isWhitespace(c); ++i) {
                ws.append(c);
            }
        }
        return ws.toString();
    }

    public boolean isAutoIndent() {
        return this.isAutoIndent;
    }

    public void setAutoIndent(boolean isAutoIndent) {
        this.isAutoIndent = isAutoIndent;
    }

    public boolean isSoftTabs() {
        return this.isSoftTabs;
    }

    public void setSoftTabs(boolean isSoftTabs) {
        this.isSoftTabs = isSoftTabs;
    }
}

