/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;

public class TextEditPopupManager {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text");
    private static TextEditPopupManager singleton = null;
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String SELECT_ALL = "selectAll";
    public static final String UNDO = "undo";
    public static final String REDO = "redo";
    private HashMap actions = new HashMap();
    private Action cut = new DefaultEditorKit.CutAction();
    private Action copy = new DefaultEditorKit.CopyAction();
    private Action paste = new DefaultEditorKit.PasteAction();
    private Action selectAll = new NSelectAllAction();
    private Action undo = new UndoAction();
    private Action redo = new RedoAction();
    private List textComps = new Vector();
    private List undoers = new Vector();
    private JTextComponent focusedComp;
    private UndoManager undoer;
    private FocusListener focusHandler = new PopupFocusHandler();
    private MouseListener popupHandler = new PopupHandler();
    private UndoListener undoHandler = new UndoListener();
    private CaretListener caretHandler = new CaretHandler();
    private JPopupMenu popup = new JPopupMenu();

    private TextEditPopupManager() {
        this.cut.putValue("Name", i18n.str(CUT));
        this.cut.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "cut.png"));
        this.copy.putValue("Name", i18n.str(COPY));
        this.copy.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "copy.png"));
        this.paste.putValue("Name", i18n.str(PASTE));
        this.paste.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "paste.png"));
        this.selectAll.putValue("AcceleratorKey", null);
        this.popup.add(this.undo);
        this.popup.add(this.redo);
        this.popup.addSeparator();
        this.popup.add(this.cut);
        this.popup.add(this.copy);
        this.popup.add(this.paste);
        this.popup.addSeparator();
        this.popup.add(this.selectAll);
        this.actions.put(CUT, this.cut);
        this.actions.put(COPY, this.copy);
        this.actions.put(PASTE, this.paste);
        this.actions.put(SELECT_ALL, this.selectAll);
        this.actions.put(UNDO, this.undo);
        this.actions.put(REDO, this.redo);
    }

    public static TextEditPopupManager getInstance() {
        if (singleton == null) {
            singleton = new TextEditPopupManager();
        }
        return singleton;
    }

    public Action getAction(String name) {
        return (Action)this.actions.get(name);
    }

    public void registerJTextComponent(JTextComponent tc) throws IllegalArgumentException {
        this.registerJTextComponent(tc, new UndoManager());
    }

    public void registerJTextComponent(JTextComponent tc, UndoManager um) throws IllegalArgumentException {
        if (tc == null || um == null) {
            throw new IllegalArgumentException("null arguments aren't allowed");
        }
        if (this.getIndexOfJTextComponent(tc) != -1) {
            throw new IllegalArgumentException("Component already registered");
        }
        tc.addFocusListener(this.focusHandler);
        tc.addCaretListener(this.caretHandler);
        tc.addMouseListener(this.popupHandler);
        tc.getDocument().addUndoableEditListener(this.undoHandler);
        this.textComps.add(new WeakReference<JTextComponent>(tc));
        this.undoers.add(um);
    }

    public void unregisterJTextComponent(JTextComponent tc) {
        int index = this.getIndexOfJTextComponent(tc);
        if (index != -1) {
            tc.removeFocusListener(this.focusHandler);
            tc.removeCaretListener(this.caretHandler);
            tc.removeMouseListener(this.popupHandler);
            tc.getDocument().removeUndoableEditListener(this.undoHandler);
            this.textComps.remove(index);
            this.undoers.remove(index);
        }
    }

    protected int getIndexOfJTextComponent(JTextComponent tc) {
        for (int i = 0; i < this.textComps.size(); ++i) {
            WeakReference wr = (WeakReference)this.textComps.get(i);
            if (wr.get() != tc) continue;
            return i;
        }
        return -1;
    }

    private void clearEmptyReferences() {
        for (int i = 0; i < this.textComps.size(); ++i) {
            WeakReference wr = (WeakReference)this.textComps.get(i);
            if (wr.get() != null) continue;
            this.undoers.set(i, null);
        }
        Iterator it = this.textComps.iterator();
        while (it.hasNext()) {
            WeakReference w = (WeakReference)it.next();
            if (w.get() != null) continue;
            it.remove();
        }
        it = this.undoers.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    private void updateActions() {
        if (this.focusedComp != null && this.focusedComp.hasFocus()) {
            this.undo.setEnabled(this.undoer.canUndo());
            this.redo.setEnabled(this.undoer.canRedo());
            boolean hasSel = this.focusedComp.getSelectedText() != null;
            this.copy.setEnabled(hasSel);
            this.cut.setEnabled(hasSel);
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        private void checkForPopupTrigger(MouseEvent e) {
            JTextComponent tc = (JTextComponent)e.getComponent();
            if (e.isPopupTrigger() && tc.isEditable()) {
                if (!tc.isFocusOwner()) {
                    tc.requestFocusInWindow();
                }
                TextEditPopupManager.this.popup.show(tc, e.getX(), e.getY());
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent e) {
            TextEditPopupManager.this.updateActions();
        }
    }

    private class PopupFocusHandler
    implements FocusListener {
        private PopupFocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                JTextComponent tc = (JTextComponent)e.getComponent();
                int index = TextEditPopupManager.this.getIndexOfJTextComponent(tc);
                if (index != -1) {
                    TextEditPopupManager.this.undoer = (UndoManager)TextEditPopupManager.this.undoers.get(index);
                    TextEditPopupManager.this.focusedComp = tc;
                    TextEditPopupManager.this.updateActions();
                }
                TextEditPopupManager.this.clearEmptyReferences();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class NSelectAllAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public NSelectAllAction() {
            super(i18n.str("select_all"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("select_all")));
        }

        public void actionPerformed(ActionEvent e) {
            this.getTextComponent(e).selectAll();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super(i18n.str(TextEditPopupManager.UNDO), UIUtils.getIcon("resources/images/x16/", "undo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem(TextEditPopupManager.UNDO)));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (TextEditPopupManager.this.undoer != null) {
                    TextEditPopupManager.this.undoer.undo();
                    TextEditPopupManager.this.updateActions();
                }
            }
            catch (Exception ex) {
                System.out.println("Cannot Undo");
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super(i18n.str(TextEditPopupManager.REDO), UIUtils.getIcon("resources/images/x16/", "redo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem(TextEditPopupManager.REDO)));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (TextEditPopupManager.this.undoer != null) {
                    TextEditPopupManager.this.undoer.redo();
                    TextEditPopupManager.this.updateActions();
                }
            }
            catch (Exception ex) {
                System.out.println("Cannot Redo");
            }
        }
    }

    private class UndoListener
    implements UndoableEditListener {
        private UndoListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            if (TextEditPopupManager.this.undoer != null) {
                TextEditPopupManager.this.undoer.addEdit(edit);
                TextEditPopupManager.this.updateActions();
            }
        }
    }
}

