/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class ClearStylesAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public ClearStylesAction() {
        super(i18n.str("clear_styles"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("clear_styles")));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl Y"));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                return ClearStylesAction.this.getEditMode() != 1;
            }
        });
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        HTMLDocument document = (HTMLDocument)editor.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)editor.getEditorKit();
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        attrs.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        int selStart = editor.getSelectionStart();
        int selEnd = editor.getSelectionEnd();
        if (selEnd > selStart) {
            document.setCharacterAttributes(selStart, selEnd - selStart, attrs, true);
        }
        kit.getInputAttributes().removeAttributes(kit.getInputAttributes());
        kit.getInputAttributes().addAttributes(attrs);
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
    }
}

