/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.ElementStyleDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.HyperlinkDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.ListDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.TablePropertiesDialog;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class HTMLElementPropertiesAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int TABLE_PROPS = 0;
    public static final int LIST_PROPS = 1;
    public static final int IMG_PROPS = 2;
    public static final int LINK_PROPS = 3;
    public static final int ELEM_PROPS = 4;
    public static final String[] PROPS = new String[]{i18n.str("table_properties_"), i18n.str("list_properties_"), i18n.str("image_properties_"), i18n.str("hyperlink_properties_"), i18n.str("object_properties_")};

    public HTMLElementPropertiesAction() {
        super(PROPS[4]);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                return HTMLElementPropertiesAction.this.getEditMode() != 1 && HTMLElementPropertiesAction.this.elementAtCaretPosition(HTMLElementPropertiesAction.this.getCurrentEditor()) != null;
            }
        });
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane ed) {
        Element elem = this.elementAtCaretPosition(ed);
        int type = this.getElementType(elem);
        int caret = ed.getCaretPosition();
        if (type == 3) {
            this.editLinkProps(elem);
        } else if (type == 2) {
            this.editImageProps(elem);
        } else if (type == 0) {
            this.editTableProps(elem);
        } else if (type == 1) {
            this.editListProps(elem);
        } else if (type == 4) {
            this.editStyleProps(elem.getParentElement());
        }
        try {
            ed.setCaretPosition(caret);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private Map getAttribs(Element elem) {
        HashMap<String, String> at = new HashMap<String, String>();
        AttributeSet a = elem.getAttributes();
        Enumeration<?> e = a.getAttributeNames();
        while (e.hasMoreElements()) {
            Object n = e.nextElement();
            if (n.toString().equals("name") && !elem.getName().equals("a")) continue;
            at.put(n.toString(), a.getAttribute(n).toString());
        }
        return at;
    }

    private String getElementHTML(Element el, Map attribs) {
        String html = "<" + el.getName();
        for (Object name : attribs.keySet()) {
            Object val = attribs.get(name);
            html = html + " " + name + "=\"" + val + "\"";
        }
        String txt = HTMLUtils.getElementHTML(el, false);
        html = html + ">\n" + txt + "\n</" + el.getName() + ">";
        return html;
    }

    private Map getLinkAttributes(Element elem) {
        String link = HTMLUtils.getElementHTML(elem, true).trim();
        Map attribs = new HashMap();
        if (link.startsWith("<a")) {
            link = link.substring(0, link.indexOf(62));
            link = link.substring(link.indexOf(32), link.length()).trim();
            attribs = HTMLUtils.tagAttribsToMap(link);
        }
        return attribs;
    }

    private void editImageProps(Element elem) {
        ImageDialog d = this.createImageDialog();
        if (d != null) {
            Map imgAttribs = this.getAttribs(elem);
            d.setImageAttributes(imgAttribs);
            d.setLocationRelativeTo(d.getParent());
            d.setVisible(true);
            if (!d.hasUserCancelled()) {
                this.replace(elem, d.getHTML());
            }
        }
    }

    private void editLinkProps(Element elem) {
        HyperlinkDialog d = this.createLinkDialog();
        if (d != null) {
            d.setAttributes(this.getLinkAttributes(elem));
            d.setLocationRelativeTo(d.getParent());
            try {
                String text = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                d.setLinkText(text);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            d.setVisible(true);
            if (!d.hasUserCancelled()) {
                this.replace(elem, d.getHTML());
            }
        }
    }

    private void editTableProps(Element paraElem) {
        HTMLDocument doc = null;
        try {
            doc = (HTMLDocument)paraElem.getDocument();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Element tdElem = HTMLUtils.getParent(paraElem, HTML.Tag.TD);
        Element trElem = HTMLUtils.getParent(paraElem, HTML.Tag.TR);
        Element tableElem = HTMLUtils.getParent(paraElem, HTML.Tag.TABLE);
        TablePropertiesDialog dlg = this.createTablePropertiesDialog();
        if (dlg == null || tdElem == null || trElem == null || tableElem == null) {
            return;
        }
        dlg.setCellAttributes(this.getAttribs(tdElem));
        dlg.setRowAttributes(this.getAttribs(trElem));
        dlg.setTableAttributes(this.getAttribs(tableElem));
        dlg.setLocationRelativeTo(dlg.getParent());
        dlg.setVisible(true);
        if (!dlg.hasUserCancelled()) {
            CompoundUndoManager.beginCompoundEdit(doc);
            try {
                String html = this.getElementHTML(tdElem, dlg.getCellAttributes());
                doc.setOuterHTML(tdElem, html);
                html = this.getElementHTML(trElem, dlg.getRowAttribures());
                doc.setOuterHTML(trElem, html);
                html = this.getElementHTML(tableElem, dlg.getTableAttributes());
                doc.setOuterHTML(tableElem, html);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            CompoundUndoManager.endCompoundEdit(doc);
        }
    }

    private void editListProps(Element elem) {
        int type;
        if ((elem = HTMLUtils.getListParent(elem)) == null) {
            return;
        }
        if (elem.getName().equals("ul")) {
            type = 0;
        } else if (elem.getName().equals("ol")) {
            type = 1;
        } else {
            return;
        }
        Map attr = this.getAttribs(elem);
        ListDialog d = this.createListDialog();
        if (d == null) {
            return;
        }
        d.setListType(type);
        d.setListAttributes(attr);
        d.setLocationRelativeTo(d.getParent());
        d.setVisible(true);
        if (!d.hasUserCancelled()) {
            attr = d.getListAttributes();
            String html = "";
            if (d.getListType() != type) {
                HTML.Tag tag = HTML.Tag.UL;
                if (d.getListType() == 1) {
                    tag = HTML.Tag.OL;
                }
                String txt = HTMLUtils.getElementHTML(elem, false);
                html = "<" + tag;
                for (Object o : attr.keySet()) {
                    html = html + " " + o + "=" + attr.get(o);
                }
                html = html + ">" + txt + "</" + tag + ">";
            } else {
                html = this.getElementHTML(elem, attr);
            }
            this.replace(elem, html);
        }
    }

    private void editStyleProps(Element elem) {
        if (elem.getName().equals("p-implied")) {
            elem = elem.getParentElement();
        }
        Map attr = this.getAttribs(elem);
        ElementStyleDialog d = this.createStyleDialog();
        if (d == null) {
            return;
        }
        d.setLocationRelativeTo(d.getParent());
        d.setStyleAttributes(attr);
        d.setVisible(true);
        if (!d.hasUserCancelled()) {
            System.err.println(elem.getName());
            String html = this.getElementHTML(elem, d.getStyleAttributes());
            System.err.println(html);
            this.replace(elem, html);
        }
    }

    protected HyperlinkDialog createLinkDialog() {
        JEditorPane c = this.getCurrentEditor();
        HyperlinkDialog d = null;
        if (c != null) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && w instanceof Frame) {
                d = new HyperlinkDialog((Frame)w);
            } else if (w != null && w instanceof Dialog) {
                d = new HyperlinkDialog((Dialog)w);
            }
        }
        return d;
    }

    protected ImageDialog createImageDialog() {
        JEditorPane c = this.getCurrentEditor();
        ImageDialog d = null;
        if (c != null) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && w instanceof Frame) {
                d = new ImageDialog((Frame)w);
            } else if (w != null && w instanceof Dialog) {
                d = new ImageDialog((Dialog)w);
            }
        }
        return d;
    }

    protected TablePropertiesDialog createTablePropertiesDialog() {
        JEditorPane c = this.getCurrentEditor();
        TablePropertiesDialog d = null;
        if (c != null) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && w instanceof Frame) {
                d = new TablePropertiesDialog((Frame)w);
            } else if (w != null && w instanceof Dialog) {
                d = new TablePropertiesDialog((Dialog)w);
            }
        }
        return d;
    }

    protected ListDialog createListDialog() {
        JEditorPane c = this.getCurrentEditor();
        ListDialog d = null;
        if (c != null) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && w instanceof Frame) {
                d = new ListDialog((Frame)w);
            } else if (w != null && w instanceof Dialog) {
                d = new ListDialog((Dialog)w);
            }
        }
        return d;
    }

    protected ElementStyleDialog createStyleDialog() {
        JEditorPane c = this.getCurrentEditor();
        ElementStyleDialog d = null;
        if (c != null) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && w instanceof Frame) {
                d = new ElementStyleDialog((Frame)w);
            } else if (w != null && w instanceof Dialog) {
                d = new ElementStyleDialog((Dialog)w);
            }
        }
        return d;
    }

    private void replace(Element elem, String html) {
        HTMLDocument document = null;
        try {
            document = (HTMLDocument)elem.getDocument();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CompoundUndoManager.beginCompoundEdit(document);
        try {
            document.setOuterHTML(elem, html);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(document);
    }

    protected void updateWysiwygContextState(JEditorPane ed) {
        int t = 4;
        Element elem = this.elementAtCaretPosition(ed);
        if (elem != null) {
            t = this.getElementType(elem);
        }
        this.putValue("Name", PROPS[t]);
    }

    private int getElementType(Element elem) {
        AttributeSet att = elem.getAttributes();
        String name = att.getAttribute(StyleConstants.NameAttribute).toString();
        if (name.equals("img")) {
            return 2;
        }
        Enumeration<?> ee = att.getAttributeNames();
        while (ee.hasMoreElements()) {
            if (!ee.nextElement().toString().equals("a")) continue;
            return 3;
        }
        if (HTMLUtils.getParent(elem, HTML.Tag.UL) != null) {
            return 1;
        }
        if (HTMLUtils.getParent(elem, HTML.Tag.OL) != null) {
            return 1;
        }
        if (HTMLUtils.getParent(elem, HTML.Tag.TD) != null) {
            return 0;
        }
        return 4;
    }

    private Element elementAtCaretPosition(JEditorPane ed) {
        if (ed == null) {
            return null;
        }
        HTMLDocument doc = (HTMLDocument)ed.getDocument();
        int caret = ed.getCaretPosition();
        Element elem = doc.getParagraphElement(caret);
        HTMLDocument.BlockElement blockElem = (HTMLDocument.BlockElement)elem;
        return blockElem.positionToElement(caret);
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
    }
}

