/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLFontColorAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public HTMLFontColorAction() {
        super(i18n.str("color_"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("color_")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "color.png"));
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        Color c = this.getColorFromUser(editor);
        if (c == null) {
            return;
        }
        String prefix = "<font color=" + HTMLUtils.colorToHex(c) + ">";
        String postfix = "</font>";
        String sel = editor.getSelectedText();
        if (sel == null) {
            editor.replaceSelection(prefix + postfix);
            int pos = editor.getCaretPosition() - postfix.length();
            if (pos >= 0) {
                editor.setCaretPosition(pos);
            }
        } else {
            sel = prefix + sel + postfix;
            editor.replaceSelection(sel);
        }
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        Color color = this.getColorFromUser(editor);
        if (color != null) {
            StyledEditorKit.ForegroundAction a = new StyledEditorKit.ForegroundAction("Color", color);
            a.actionPerformed(e);
        }
    }

    private Color getColorFromUser(Component c) {
        Window win = SwingUtilities.getWindowAncestor(c);
        if (win != null) {
            c = win;
        }
        Color color = JColorChooser.showDialog(c, "Color", Color.black);
        return color;
    }
}

