/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLFontSizeAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int XXSMALL = 0;
    public static final int XSMALL = 1;
    public static final int SMALL = 2;
    public static final int MEDIUM = 3;
    public static final int LARGE = 4;
    public static final int XLARGE = 5;
    public static final int XXLARGE = 6;
    private static final String SML = i18n.str("small");
    private static final String MED = i18n.str("medium");
    private static final String LRG = i18n.str("large");
    public static final int[] FONT_SIZES = new int[]{8, 10, 12, 14, 18, 24, 36};
    public static final String[] SIZES = new String[]{"xx-" + SML, "x-" + SML, SML, MED, LRG, "x-" + LRG, "xx-" + LRG};
    private int size;

    public HTMLFontSizeAction(int size) throws IllegalArgumentException {
        super("");
        if (size < 0 || size > 6) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.size = size;
        this.putValue("Name", SIZES[size]);
        this.putValue("BUTTON_TYPE", "radio");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void updateWysiwygContextState(JEditorPane ed) {
        AttributeSet at = HTMLUtils.getCharacterAttributes(ed);
        if (at.isDefined(StyleConstants.FontSize)) {
            this.setSelected(at.containsAttribute(StyleConstants.FontSize, new Integer(FONT_SIZES[this.size])));
        } else {
            this.setSelected(this.size == 3);
        }
    }

    protected void updateSourceContextState(JEditorPane ed) {
        this.setSelected(false);
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        String prefix = "<font size=" + (this.size + 1) + ">";
        String postfix = "</font>";
        String sel = editor.getSelectedText();
        if (sel == null) {
            editor.replaceSelection(prefix + postfix);
            int pos = editor.getCaretPosition() - postfix.length();
            if (pos >= 0) {
                editor.setCaretPosition(pos);
            }
        } else {
            sel = prefix + sel + postfix;
            editor.replaceSelection(sel);
        }
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        StyledEditorKit.FontSizeAction a = new StyledEditorKit.FontSizeAction(SIZES[this.size], FONT_SIZES[this.size]);
        a.actionPerformed(e);
    }
}

