/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLInlineAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int EM = 0;
    public static final int STRONG = 1;
    public static final int CODE = 2;
    public static final int CITE = 3;
    public static final int SUP = 4;
    public static final int SUB = 5;
    public static final int BOLD = 6;
    public static final int ITALIC = 7;
    public static final int UNDERLINE = 8;
    public static final int STRIKE = 9;
    public static final String[] INLINE_TYPES = new String[]{i18n.str("emphasis"), i18n.str("strong"), i18n.str("code"), i18n.str("cite"), i18n.str("superscript"), i18n.str("subscript"), i18n.str("bold"), i18n.str("italic"), i18n.str("underline"), i18n.str("strikethrough")};
    private static final int[] MNEMS = new int[]{i18n.mnem("emphasis"), i18n.mnem("strong"), i18n.mnem("code"), i18n.mnem("cite"), i18n.mnem("superscript"), i18n.mnem("subscript"), i18n.mnem("bold"), i18n.mnem("italic"), i18n.mnem("underline"), i18n.mnem("strikethrough")};
    private int type;

    public HTMLInlineAction(int itype) throws IllegalArgumentException {
        super("");
        this.type = itype;
        if (this.type < 0 || this.type >= INLINE_TYPES.length) {
            throw new IllegalArgumentException("Illegal Argument");
        }
        this.putValue("Name", INLINE_TYPES[this.type]);
        this.putValue("MnemonicKey", new Integer(MNEMS[this.type]));
        ImageIcon ico = null;
        KeyStroke ks = null;
        if (this.type == 6) {
            ico = UIUtils.getIcon("resources/images/x16/", "bold.png");
            ks = KeyStroke.getKeyStroke(66, 2);
        } else if (this.type == 7) {
            ico = UIUtils.getIcon("resources/images/x16/", "italic.png");
            ks = KeyStroke.getKeyStroke(73, 2);
        } else if (this.type == 8) {
            ico = UIUtils.getIcon("resources/images/x16/", "underline.png");
            ks = KeyStroke.getKeyStroke(85, 2);
        }
        this.putValue("SmallIcon", ico);
        this.putValue("AcceleratorKey", ks);
        this.putValue("BUTTON_TYPE", "checkbox");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void updateWysiwygContextState(JEditorPane ed) {
        this.setSelected(this.isDefined(HTMLUtils.getCharacterAttributes(ed)));
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        HTML.Tag tag = this.getTag();
        String prefix = "<" + tag.toString() + ">";
        String postfix = "</" + tag.toString() + ">";
        String sel = editor.getSelectedText();
        if (sel == null) {
            editor.replaceSelection(prefix + postfix);
            int pos = editor.getCaretPosition() - postfix.length();
            if (pos >= 0) {
                editor.setCaretPosition(pos);
            }
        } else {
            sel = prefix + sel + postfix;
            editor.replaceSelection(sel);
        }
    }

    public HTML.Tag getTag() {
        return this.getTagForType(this.type);
    }

    private HTML.Tag getTagForType(int type) {
        HTML.Tag tag = null;
        switch (type) {
            case 0: {
                tag = HTML.Tag.EM;
                break;
            }
            case 1: {
                tag = HTML.Tag.STRONG;
                break;
            }
            case 2: {
                tag = HTML.Tag.CODE;
                break;
            }
            case 4: {
                tag = HTML.Tag.SUP;
                break;
            }
            case 5: {
                tag = HTML.Tag.SUB;
                break;
            }
            case 3: {
                tag = HTML.Tag.CITE;
                break;
            }
            case 6: {
                tag = HTML.Tag.B;
                break;
            }
            case 7: {
                tag = HTML.Tag.I;
                break;
            }
            case 8: {
                tag = HTML.Tag.U;
                break;
            }
            case 9: {
                tag = HTML.Tag.STRIKE;
            }
        }
        return tag;
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        CompoundUndoManager.beginCompoundEdit(editor.getDocument());
        this.toggleStyle(editor);
        CompoundUndoManager.endCompoundEdit(editor.getDocument());
    }

    private boolean isDefined(AttributeSet attr) {
        boolean hasSC = false;
        if (this.type == 4) {
            hasSC = StyleConstants.isSuperscript(attr);
        } else if (this.type == 5) {
            hasSC = StyleConstants.isSubscript(attr);
        } else if (this.type == 6) {
            hasSC = StyleConstants.isBold(attr);
        } else if (this.type == 7) {
            hasSC = StyleConstants.isItalic(attr);
        } else if (this.type == 8) {
            hasSC = StyleConstants.isUnderline(attr);
        } else if (this.type == 9) {
            hasSC = StyleConstants.isStrikeThrough(attr);
        }
        return hasSC || attr.getAttribute(this.getTag()) != null;
    }

    private void toggleStyle(JEditorPane editor) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttributes(HTMLUtils.getCharacterAttributes(editor));
        boolean enable = !this.isDefined(attr);
        HTML.Tag tag = this.getTag();
        if (enable) {
            attr = new SimpleAttributeSet();
            attr.addAttribute(tag, new SimpleAttributeSet());
            HTMLUtils.setCharacterAttributes(editor, attr);
        } else {
            if (this.type == 6) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.FONT_WEIGHT, "bold");
            } else if (this.type == 7) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.FONT_STYLE, "italic");
            } else if (this.type == 8) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.TEXT_DECORATION, "underline");
            } else if (this.type == 9) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.TEXT_DECORATION, "line-through");
            } else if (this.type == 4) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.VERTICAL_ALIGN, "sup");
            } else if (this.type == 5) {
                HTMLUtils.removeCharacterAttribute(editor, CSS.Attribute.VERTICAL_ALIGN, "sub");
            }
            HTMLUtils.removeCharacterAttribute(editor, tag);
        }
        this.setSelected(enable);
    }

    protected void updateSourceContextState(JEditorPane ed) {
        this.setSelected(false);
    }
}

