/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class PasteAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public PasteAction() {
        super(i18n.str("paste"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("paste")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "paste.png"));
        this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "paste.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                return true;
            }
        });
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    protected void updateWysiwygContextState(JEditorPane wysEditor) {
        this.updateEnabledState();
    }

    protected void updateSourceContextState(JEditorPane srcEditor) {
        this.updateEnabledState();
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
        editor.paste();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane editor) {
        HTMLEditorKit ekit = (HTMLEditorKit)editor.getEditorKit();
        HTMLDocument document = (HTMLDocument)editor.getDocument();
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            CompoundUndoManager.beginCompoundEdit(document);
            Transferable content = clip.getContents((Object)this);
            String txt = content.getTransferData(new DataFlavor(String.class, "String")).toString();
            document.replace(editor.getSelectionStart(), editor.getSelectionEnd() - editor.getSelectionStart(), txt, ekit.getInputAttributes());
        }
        catch (Exception ex) {
        }
        finally {
            CompoundUndoManager.endCompoundEdit(document);
        }
    }
}

