/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.ElementWriter;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class TableEditAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int INSERT_CELL = 0;
    public static final int DELETE_CELL = 1;
    public static final int INSERT_ROW = 2;
    public static final int DELETE_ROW = 3;
    public static final int INSERT_COL = 4;
    public static final int DELETE_COL = 5;
    private static final String[] NAMES = new String[]{i18n.str("insert_cell"), i18n.str("delete_cell"), i18n.str("insert_row"), i18n.str("delete_row"), i18n.str("insert_column"), i18n.str("delete_column")};
    private int type;

    public TableEditAction(int type) throws IllegalArgumentException {
        super("");
        if (type < 0 || type >= NAMES.length) {
            throw new IllegalArgumentException("Invalid type");
        }
        this.type = type;
        this.putValue("Name", NAMES[type]);
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action a) {
                return TableEditAction.this.getEditMode() != 1 && TableEditAction.this.isInTD(TableEditAction.this.getCurrentEditor());
            }
        });
    }

    protected void wysiwygEditPerformed(ActionEvent e, JEditorPane ed) {
        HTMLDocument document = (HTMLDocument)ed.getDocument();
        Element curElem = document.getParagraphElement(ed.getCaretPosition());
        Element td = HTMLUtils.getParent(curElem, HTML.Tag.TD);
        Element tr = HTMLUtils.getParent(curElem, HTML.Tag.TR);
        if (td == null || tr == null || document == null) {
            return;
        }
        CompoundUndoManager.beginCompoundEdit(document);
        try {
            if (this.type == 0) {
                document.insertAfterEnd(td, "<td></td>");
            } else if (this.type == 1) {
                this.removeCell(td);
            } else if (this.type == 2) {
                this.insertRowAfter(tr);
            } else if (this.type == 3) {
                this.removeRow(tr);
            } else if (this.type == 4) {
                this.insertColumnAfter(td);
            } else if (this.type == 5) {
                this.removeColumn(td);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(document);
    }

    private void removeCell(Element td) throws Exception {
        Element tr = HTMLUtils.getParent(td, HTML.Tag.TR);
        if (tr != null && td.getName().equals("td")) {
            if (td.getEndOffset() != tr.getEndOffset()) {
                this.remove(td);
            } else if (this.getRowCellCount(tr) <= 1) {
                this.remove(tr);
            } else {
                StringWriter out = new StringWriter();
                ElementWriter w = new ElementWriter((Writer)out, tr, tr.getStartOffset(), td.getStartOffset());
                w.write();
                HTMLDocument doc = (HTMLDocument)tr.getDocument();
                doc.setOuterHTML(tr, out.toString());
            }
        }
    }

    private void insertRowAfter(Element tr) throws Exception {
        Element table = HTMLUtils.getParent(tr, HTML.Tag.TABLE);
        if (table != null && tr.getName().equals("tr")) {
            HTMLDocument doc = (HTMLDocument)tr.getDocument();
            if (tr.getEndOffset() != table.getEndOffset()) {
                doc.insertAfterEnd(tr, this.getRowHTML(tr));
            } else {
                AttributeSet atr = table.getAttributes();
                String tbl = HTMLUtils.getElementHTML(table, false);
                tbl = tbl + this.getRowHTML(tr);
                tbl = HTMLUtils.createTag(HTML.Tag.TABLE, atr, tbl);
                doc.setOuterHTML(table, tbl);
            }
        }
    }

    private void removeRow(Element tr) throws Exception {
        Element table = HTMLUtils.getParent(tr, HTML.Tag.TABLE);
        if (table != null && tr.getName().equals("tr")) {
            if (tr.getEndOffset() != table.getEndOffset()) {
                this.remove(tr);
            } else if (this.getTableRowCount(table) <= 1) {
                this.remove(table);
            } else {
                StringWriter out = new StringWriter();
                ElementWriter w = new ElementWriter((Writer)out, table, table.getStartOffset(), tr.getStartOffset());
                w.write();
                HTMLDocument doc = (HTMLDocument)tr.getDocument();
                doc.setOuterHTML(table, out.toString());
            }
        }
    }

    private int getTableRowCount(Element table) {
        int count = 0;
        for (int i = 0; i < table.getElementCount(); ++i) {
            Element e = table.getElement(i);
            if (!e.getName().equals("tr")) continue;
            ++count;
        }
        return count;
    }

    private int getRowCellCount(Element tr) {
        int count = 0;
        for (int i = 0; i < tr.getElementCount(); ++i) {
            Element e = tr.getElement(i);
            if (!e.getName().equals("td")) continue;
            ++count;
        }
        return count;
    }

    private void remove(Element el) throws BadLocationException {
        int start = el.getStartOffset();
        int len = el.getEndOffset() - start;
        Document document = el.getDocument();
        if (el.getEndOffset() > document.getLength()) {
            len = document.getLength() - start;
        }
        document.remove(start, len);
    }

    private int getCellIndex(Element tr, Element td) {
        int tdIndex = -1;
        for (int i = 0; i < tr.getElementCount(); ++i) {
            Element e = tr.getElement(i);
            if (e.getStartOffset() != td.getStartOffset()) continue;
            tdIndex = i;
            break;
        }
        return tdIndex;
    }

    private void removeColumn(Element td) throws Exception {
        Element tr = HTMLUtils.getParent(td, HTML.Tag.TR);
        int tdIndex = this.getCellIndex(tr, td);
        if (tdIndex == -1) {
            return;
        }
        Element table = HTMLUtils.getParent(tr, HTML.Tag.TABLE);
        for (int i = 0; i < table.getElementCount(); ++i) {
            Element e;
            Element row = table.getElement(i);
            if (!row.getName().equals("tr") || (e = row.getElement(tdIndex)) == null || !e.getName().equals("td")) continue;
            this.removeCell(e);
        }
    }

    private void insertColumnAfter(Element td) throws Exception {
        Element tr = HTMLUtils.getParent(td, HTML.Tag.TR);
        HTMLDocument doc = (HTMLDocument)tr.getDocument();
        int tdIndex = this.getCellIndex(tr, td);
        if (tdIndex == -1) {
            return;
        }
        Element table = HTMLUtils.getParent(tr, HTML.Tag.TABLE);
        for (int i = 0; i < table.getElementCount(); ++i) {
            Element row = table.getElement(i);
            if (!row.getName().equals("tr")) continue;
            AttributeSet attr = row.getAttributes();
            int cellCount = row.getElementCount();
            String rowHTML = "";
            String cell = "<td></td>";
            for (int j = 0; j < cellCount; ++j) {
                Element e = row.getElement(j);
                rowHTML = rowHTML + HTMLUtils.getElementHTML(e, true);
                if (j != tdIndex) continue;
                rowHTML = rowHTML + cell;
            }
            int tds = row.getElementCount() - 1;
            if (tds < tdIndex) {
                while (tds <= tdIndex) {
                    rowHTML = rowHTML + cell;
                    ++tds;
                }
            }
            rowHTML = HTMLUtils.createTag(HTML.Tag.TR, attr, rowHTML);
            doc.setOuterHTML(row, rowHTML);
        }
    }

    private String getRowHTML(Element tr) {
        String trTag = "<tr>";
        if (tr.getName().equals("tr")) {
            for (int i = 0; i < tr.getElementCount(); ++i) {
                if (!tr.getElement(i).getName().equals("td")) continue;
                trTag = trTag + "<td></td>";
            }
        }
        trTag = trTag + "</tr>";
        return trTag;
    }

    private boolean isInTD(JEditorPane tc) {
        Element td = null;
        if (tc != null) {
            HTMLDocument doc = (HTMLDocument)tc.getDocument();
            try {
                Element curElem = doc.getParagraphElement(tc.getCaretPosition());
                td = HTMLUtils.getParent(curElem, HTML.Tag.TD);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return td != null;
    }

    protected void updateWysiwygContextState(JEditorPane wysEditor) {
        boolean isInTd = this.isInTD(wysEditor);
        if (isInTd && !this.isEnabled() || this.isEnabled() && !isInTd) {
            this.updateEnabled();
        }
    }

    protected void sourceEditPerformed(ActionEvent e, JEditorPane editor) {
    }
}

