/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLOptionDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkPanel;

public class HyperlinkDialog
extends HTMLOptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "link.png");
    private static String title = i18n.str("hyperlink");
    private static String desc = i18n.str("hyperlink_desc");
    private LinkPanel linkPanel;

    public HyperlinkDialog(Frame parent) {
        this(parent, title, desc, icon, true);
    }

    public HyperlinkDialog(Dialog parent) {
        this(parent, title, desc, icon, true);
    }

    public HyperlinkDialog(Dialog parent, String title, String desc, Icon ico, boolean urlFieldEnabled) {
        super(parent, title, desc, ico);
        this.init(urlFieldEnabled);
    }

    public HyperlinkDialog(Frame parent, String title, String desc, Icon ico, boolean urlFieldEnabled) {
        super(parent, title, desc, ico);
        this.init(urlFieldEnabled);
    }

    private void init(boolean urlFieldEnabled) {
        this.linkPanel = new LinkPanel(urlFieldEnabled);
        this.linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.linkPanel);
        this.setSize(315, 370);
        this.setResizable(false);
    }

    public Map getAttributes() {
        return this.linkPanel.getAttributes();
    }

    public void setAttributes(Map attribs) {
        this.linkPanel.setAttributes(attribs);
    }

    public void setLinkText(String text) {
        this.linkPanel.setLinkText(text);
    }

    public String getLinkText() {
        return this.linkPanel.getLinkText();
    }

    public String getHTML() {
        String html = "<a";
        Map ht = this.getAttributes();
        for (Object k : ht.keySet()) {
            html = html + " " + k + "=" + "\"" + ht.get(k) + "\"";
        }
        html = html + ">" + this.getLinkText() + "</a>";
        return html;
    }
}

