/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.ImageAttributesPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkAttributesPanel;

public class ImagePanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private ImageAttributesPanel imageAttrPanel;
    private LinkAttributesPanel linkAttrPanel;
    private JTextField linkUrlField;
    private JCheckBox linkCB;

    public ImagePanel() {
        this(new Hashtable());
    }

    public ImagePanel(Hashtable at) {
        this.initialize();
        this.setAttributes(at);
        this.updateComponentsFromAttribs();
    }

    private String createAttribs(Map ht) {
        String html = "";
        for (Object k : ht.keySet()) {
            html = html + " " + k + "=" + "\"" + ht.get(k) + "\"";
        }
        return html;
    }

    public void updateComponentsFromAttribs() {
        this.imageAttrPanel.setAttributes(this.attribs);
        if (this.attribs.containsKey("a")) {
            this.linkCB.setSelected(true);
            this.linkAttrPanel.setEnabled(true);
            this.linkUrlField.setEditable(true);
            Map ht = HTMLUtils.tagAttribsToMap(this.attribs.get("a").toString());
            if (ht.containsKey("href")) {
                this.linkUrlField.setText(ht.get("href").toString());
            } else {
                this.linkUrlField.setText("");
            }
            this.linkAttrPanel.setAttributes(ht);
        } else {
            this.linkCB.setSelected(false);
            this.linkAttrPanel.setEnabled(false);
            this.linkUrlField.setEditable(false);
            this.linkAttrPanel.setAttributes(new HashMap());
        }
    }

    public void updateAttribsFromComponents() {
        this.imageAttrPanel.updateAttribsFromComponents();
        this.linkAttrPanel.updateAttribsFromComponents();
        if (this.linkCB.isSelected()) {
            Map ht = this.linkAttrPanel.getAttributes();
            ht.put("href", this.linkUrlField.getText());
            this.attribs.put("a", this.createAttribs(ht));
        } else {
            this.attribs.remove("a");
        }
    }

    private void initialize() {
        JTabbedPane tabs = new JTabbedPane();
        this.linkAttrPanel = new LinkAttributesPanel();
        this.linkCB = new JCheckBox(i18n.str("link"));
        this.linkUrlField = new JTextField();
        JPanel urlPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridy = 0;
        urlPanel.add((Component)this.linkCB, gbc);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 1;
        urlPanel.add((Component)this.linkUrlField, gbc);
        JPanel linkPanel = new JPanel(new BorderLayout(5, 5));
        linkPanel.add((Component)urlPanel, "North");
        linkPanel.add((Component)this.linkAttrPanel, "Center");
        linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.imageAttrPanel = new ImageAttributesPanel();
        this.imageAttrPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabs.addTab(i18n.str("image"), this.imageAttrPanel);
        tabs.addTab(i18n.str("link"), linkPanel);
        this.setLayout(new BorderLayout());
        this.add(tabs);
        this.linkAttrPanel.setEnabled(this.linkCB.isSelected());
        this.linkUrlField.setEditable(this.linkCB.isSelected());
        this.linkCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ImagePanel.this.linkAttrPanel.setEnabled(ImagePanel.this.linkCB.isSelected());
                ImagePanel.this.linkUrlField.setEditable(ImagePanel.this.linkCB.isSelected());
            }
        });
        TextEditPopupManager.getInstance().registerJTextComponent(this.linkUrlField);
    }
}

