/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.atlanticbb.tantlinger.ui.text.TextEditPopupManager;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLAttributeEditorPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkAttributesPanel;

public class LinkPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private JPanel hlinkPanel = null;
    private JLabel urlLabel = null;
    private JLabel textLabel = null;
    private JTextField urlField = null;
    private JTextField textField = null;
    private HTMLAttributeEditorPanel linkAttrPanel = null;
    private boolean urlFieldEnabled;

    public LinkPanel() {
        this(true);
    }

    public LinkPanel(boolean urlFieldEnabled) {
        this(new Hashtable(), urlFieldEnabled);
    }

    public LinkPanel(Hashtable attr, boolean urlFieldEnabled) {
        this.urlFieldEnabled = urlFieldEnabled;
        this.initialize();
        this.setAttributes(attr);
        this.updateComponentsFromAttribs();
    }

    public void updateComponentsFromAttribs() {
        this.linkAttrPanel.updateComponentsFromAttribs();
        if (this.attribs.containsKey("href")) {
            this.urlField.setText(this.attribs.get("href").toString());
        } else {
            this.urlField.setText("");
        }
    }

    public void updateAttribsFromComponents() {
        this.linkAttrPanel.updateAttribsFromComponents();
        this.attribs.put("href", this.urlField.getText());
    }

    public void setAttributes(Map at) {
        super.setAttributes(at);
        this.linkAttrPanel.setAttributes(this.attribs);
    }

    public void setLinkText(String text) {
        this.textField.setText(text);
    }

    public String getLinkText() {
        return this.textField.getText();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.setSize(328, 218);
        this.add((Component)this.getHlinkPanel(), "North");
        this.add((Component)this.getLinkAttrPanel(), "Center");
        TextEditPopupManager popupMan = TextEditPopupManager.getInstance();
        popupMan.registerJTextComponent(this.urlField);
        popupMan.registerJTextComponent(this.textField);
    }

    private JPanel getHlinkPanel() {
        if (this.hlinkPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints1.gridy = 1;
            this.textLabel = new JLabel();
            this.textLabel.setText(i18n.str("text"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridy = 0;
            this.urlLabel = new JLabel();
            this.urlLabel.setText(i18n.str("url"));
            this.hlinkPanel = new JPanel();
            this.hlinkPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("link"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.hlinkPanel.setLayout(new GridBagLayout());
            this.hlinkPanel.add((Component)this.urlLabel, gridBagConstraints);
            this.hlinkPanel.add((Component)this.textLabel, gridBagConstraints1);
            this.hlinkPanel.add((Component)this.getUrlField(), gridBagConstraints2);
            this.hlinkPanel.add((Component)this.getTextField(), gridBagConstraints3);
        }
        return this.hlinkPanel;
    }

    private JTextField getUrlField() {
        if (this.urlField == null) {
            this.urlField = new JTextField();
            this.urlField.setEditable(this.urlFieldEnabled);
        }
        return this.urlField;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
        }
        return this.textField;
    }

    private JPanel getLinkAttrPanel() {
        if (this.linkAttrPanel == null) {
            this.linkAttrPanel = new LinkAttributesPanel();
        }
        return this.linkAttrPanel;
    }
}

