/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.OptionDialog;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.TableAttributesPanel;

public class NewTableDialog
extends OptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private LayoutPanel layoutPanel = new LayoutPanel();
    private TableAttributesPanel propsPanel;
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "table.png");

    public NewTableDialog(Frame parent) {
        super(parent, i18n.str("new_table"), i18n.str("new_table_desc"), icon);
        this.init();
    }

    public NewTableDialog(Dialog parent) {
        super(parent, i18n.str("new_table"), i18n.str("new_table_desc"), icon);
        this.init();
    }

    private void init() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("border", "1");
        ht.put("width", "100%");
        this.propsPanel = new TableAttributesPanel();
        this.propsPanel.setAttributes(ht);
        this.propsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.str("properties")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.layoutPanel, "North");
        mainPanel.add((Component)this.propsPanel, "Center");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPanel);
        this.setSize(new Dimension(330, 380));
        this.setResizable(false);
    }

    public String getHTML() {
        String html = "<table";
        Map attribs = this.propsPanel.getAttributes();
        Iterator e = attribs.keySet().iterator();
        while (e.hasNext()) {
            String key = e.next().toString();
            String val = attribs.get(key).toString();
            html = html + ' ' + key + "=\"" + val + "\"";
        }
        html = html + ">\n";
        int numRows = this.layoutPanel.getRows();
        int numCols = this.layoutPanel.getColumns();
        for (int row = 1; row <= numRows; ++row) {
            html = html + "<tr>\n";
            for (int col = 1; col <= numCols; ++col) {
                html = html + "\t<td>\n</td>\n";
            }
            html = html + "</tr>\n";
        }
        return html + "</table>";
    }

    private class LayoutPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel rowsLabel = null;
        private JLabel colsLabel = null;
        private int iRows;
        private int iCols;
        private JSpinner rowsField = null;
        private JSpinner colsField = null;

        public LayoutPanel() {
            this(1, 1);
        }

        public LayoutPanel(int r, int c) {
            this.iRows = r > 0 ? r : 1;
            this.iCols = c > 0 ? c : 1;
            this.initialize();
        }

        public int getRows() {
            return Integer.parseInt(this.rowsField.getModel().getValue().toString());
        }

        public int getColumns() {
            return Integer.parseInt(this.colsField.getModel().getValue().toString());
        }

        private void initialize() {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 15);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints1.gridy = 0;
            this.colsLabel = new JLabel();
            this.colsLabel.setText(i18n.str("columns"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 0;
            this.rowsLabel = new JLabel();
            this.rowsLabel.setText(i18n.str("rows"));
            this.setLayout(new GridBagLayout());
            this.setSize(330, 60);
            this.setPreferredSize(new Dimension(330, 60));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, i18n.str("layout"), 0, 0, null, null), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.add((Component)this.rowsLabel, gridBagConstraints);
            this.add((Component)this.colsLabel, gridBagConstraints1);
            this.add((Component)this.getRowsField(), gridBagConstraints6);
            this.add((Component)this.getColsField(), gridBagConstraints7);
        }

        private JSpinner getRowsField() {
            if (this.rowsField == null) {
                this.rowsField = new JSpinner(new SpinnerNumberModel(this.iRows, 1, 999, 1));
            }
            return this.rowsField;
        }

        private JSpinner getColsField() {
            if (this.colsField == null) {
                this.colsField = new JSpinner(new SpinnerNumberModel(this.iCols, 1, 999, 1));
            }
            return this.colsField;
        }
    }
}

