/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.CustomStyle;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public class StyleRange {
    protected int startIndex;
    protected int length;
    protected Color foreground;
    protected Color background;
    protected int style;
    protected List<CustomStyle> customStyles;

    public StyleRange(StyleRange styleRange) {
        this(styleRange.getStartIndex(), styleRange.getLength(), styleRange.getStyle(), styleRange.getForeground(), styleRange.getBackground(), StyleRange.getCustomStyles(styleRange));
    }

    public StyleRange(int startIndex, int length, CustomStyle ... customStyles) {
        this(startIndex, length, -1, (Color)null, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, CustomStyle ... customStyles) {
        this(startIndex, length, style, (Color)null, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, Color foreground, CustomStyle ... customStyles) {
        this(startIndex, length, -1, foreground, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, Color foreground, Color background, CustomStyle ... customStyles) {
        this(startIndex, length, -1, foreground, background, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, Color foreground, CustomStyle ... customStyles) {
        this(startIndex, length, style, foreground, (Color)null, customStyles);
    }

    public StyleRange(int startIndex, int length, int style, Color foreground, Color background, CustomStyle ... customStyles) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("Style start index cannot be less than zero");
        }
        if (length == 0) {
            throw new IllegalArgumentException("Style length cannot be zero");
        }
        this.startIndex = startIndex;
        this.length = length;
        this.foreground = foreground;
        this.background = background;
        this.style = style;
        this.customStyles = Arrays.asList(customStyles);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getStyle() {
        return this.style;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public boolean isStrikeThrough() {
        return this.customStyles.contains((Object)CustomStyle.strikeThrough);
    }

    public boolean isDoubleStrikeThrough() {
        return this.customStyles.contains((Object)CustomStyle.doubleStrikeThrough);
    }

    public boolean isWaved() {
        return this.customStyles.contains((Object)CustomStyle.waved);
    }

    public boolean isUnderlined() {
        return this.customStyles.contains((Object)CustomStyle.underlined);
    }

    public boolean isSuperscript() {
        return this.customStyles.contains((Object)CustomStyle.superscript);
    }

    public boolean isSubscript() {
        return this.customStyles.contains((Object)CustomStyle.subscript);
    }

    public List<CustomStyle> getCustomStyle() {
        return this.customStyles;
    }

    protected static CustomStyle[] getCustomStyles(StyleRange styleRange) {
        return styleRange.getCustomStyle().toArray(new CustomStyle[styleRange.getCustomStyle().size()]);
    }
}

