/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyledLabelPainter;
import com.alee.extended.label.StyledLabelUtils;
import com.alee.extended.label.TextRange;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.label.WebStyledLabelStyle;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.log.Log;
import com.alee.managers.style.skin.web.WebLabelPainter;
import com.alee.utils.FontUtils;
import com.alee.utils.SwingUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WebStyledLabelPainter<E extends WebStyledLabel>
extends WebLabelPainter<E>
implements StyledLabelPainter<E>,
SwingConstants {
    protected int preferredRowCount = WebStyledLabelStyle.preferredRowCount;
    protected boolean ignoreColorSettings = WebStyledLabelStyle.ignoreColorSettings;
    protected float scriptFontRatio = WebStyledLabelStyle.scriptFontRatio;
    protected String truncatedTextSuffix = WebStyledLabelStyle.truncatedTextSuffix;
    protected final List<TextRange> textRanges = new ArrayList<TextRange>();
    protected boolean retrievingPreferredSize = false;
    protected boolean truncated = false;

    public int getPreferredRowCount() {
        return this.preferredRowCount;
    }

    @Override
    public void setPreferredRowCount(int rows) {
        this.preferredRowCount = rows;
        this.revalidate();
        this.repaint();
    }

    public boolean isIgnoreColorSettings() {
        return this.ignoreColorSettings;
    }

    @Override
    public void setIgnoreColorSettings(boolean ignore) {
        this.ignoreColorSettings = ignore;
        this.repaint();
    }

    public float getScriptFontRatio() {
        return this.scriptFontRatio;
    }

    @Override
    public void setScriptFontRatio(float ratio) {
        this.scriptFontRatio = ratio;
        this.revalidate();
        this.repaint();
    }

    public String getTruncatedTextSuffix() {
        return this.truncatedTextSuffix;
    }

    @Override
    public void setTruncatedTextSuffix(String suffix) {
        this.truncatedTextSuffix = suffix;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void updateTextRanges() {
        this.textRanges.clear();
    }

    @Override
    protected void paintEnabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        this.paintStyledText(label, g2d, textX, textY);
    }

    @Override
    protected void paintDisabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        this.paintStyledText(label, g2d, textX, textY);
    }

    protected void paintStyledText(E label, Graphics2D g, int textX, int textY) {
        this.truncated = false;
        int labelWidth = this.getLabelWidth(label);
        int textWidth = this.getTextWidth(label);
        int w = Math.min(labelWidth, textWidth);
        this.paintStyledTextImpl(label, g, textX, textY, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLabelWidth(E label) {
        int lw = ((JComponent)label).getWidth();
        if (((WebStyledLabel)label).isLineWrap()) {
            int oldPreferredWidth = ((WebStyledLabel)label).getPreferredWidth();
            int oldRows = ((WebStyledLabel)label).getRows();
            try {
                ((WebStyledLabel)label).setRows(0);
                lw = this.getPreferredSize(label).width;
                ((WebStyledLabel)label).setPreferredWidth(oldPreferredWidth > 0 ? Math.min(((JComponent)label).getWidth(), oldPreferredWidth) : ((JComponent)label).getWidth());
                Dimension sizeOnWidth = this.getPreferredSize(label);
                if (sizeOnWidth.width < lw) {
                    lw = sizeOnWidth.width;
                }
            }
            finally {
                ((WebStyledLabel)label).setPreferredWidth(oldPreferredWidth);
                ((WebStyledLabel)label).setRows(oldRows);
            }
        }
        return lw;
    }

    protected int getTextWidth(E label) {
        int textWidth = ((JComponent)label).getWidth();
        if (((JComponent)label).getInsets() != null) {
            textWidth -= ((JComponent)label).getInsets().left + ((JComponent)label).getInsets().right;
        }
        if (((JLabel)label).getIcon() != null && ((JLabel)label).getHorizontalTextPosition() != 0) {
            textWidth -= ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
        }
        return textWidth;
    }

    protected int paintStyledTextImpl(E label, Graphics2D g, int textX, int textY, int w) {
        FontMetrics fm2;
        Insets insets = ((JComponent)label).getInsets();
        int labelHeight = this.getLabelHeight(label, insets);
        int startX = this.getStartX(label, textX, insets);
        int endX = w + startX;
        int mnemonicIndex = ((JLabel)label).getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WebLookAndFeel && WebLookAndFeel.isMnemonicHidden() || UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        int x = startX;
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        int maxRowHeight = fm.getHeight();
        int minStartY = fm.getAscent();
        int horizontalAlignment = ((JLabel)label).getHorizontalAlignment();
        switch (horizontalAlignment) {
            case 10: {
                horizontalAlignment = ((Component)label).getComponentOrientation().isLeftToRight() ? 2 : 4;
                break;
            }
            case 11: {
                horizontalAlignment = ((Component)label).getComponentOrientation().isLeftToRight() ? 4 : 2;
            }
        }
        for (TextRange textRange : this.textRanges) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style == null || (style.getStyle() == -1 || font.getStyle() == style.getStyle()) && font.getSize() == size) continue;
            font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
            fm2 = ((JComponent)label).getFontMetrics(font);
            maxRowHeight = Math.max(maxRowHeight, fm2.getHeight());
            minStartY = Math.max(minStartY, fm2.getAscent());
        }
        boolean lineWrap = ((WebStyledLabel)label).isLineWrap();
        if (!lineWrap) {
            for (TextRange textRange : this.textRanges) {
                if (!textRange.text.endsWith("\n")) continue;
                lineWrap = true;
                break;
            }
        }
        if (lineWrap && textY < minStartY) {
            textY = minStartY;
        }
        int nextRowStartIndex = 0;
        int rowCount = 0;
        int rowStartOffset = 0;
        for (int i = 0; i < this.textRanges.size(); ++i) {
            boolean displayMnemonic;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            if (mnemonicIndex >= 0 && textRange.text.length() - nextRowStartIndex > mnemonicIndex - charDisplayed) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            } else {
                displayMnemonic = false;
            }
            charDisplayed += textRange.text.length() - nextRowStartIndex;
            if (textRange.text.contains("\r") || textRange.text.contains("\n")) {
                boolean lastRow;
                boolean bl = lastRow = ((WebStyledLabel)label).getMaximumRows() > 0 && rowCount >= ((WebStyledLabel)label).getMaximumRows() - 1 || textY + maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap()) > labelHeight;
                if (horizontalAlignment != 2 && g != null) {
                    if (lastRow && i != this.textRanges.size() - 1) {
                        x += fm.stringWidth(this.truncatedTextSuffix);
                    }
                    this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStartIndex() + textRange.text.length(), lastRow);
                }
                rowStartOffset = style.getStartIndex();
                nextRowStartIndex = 0;
                nextFm2 = null;
                if (!lastRow) {
                    rowStartOffset += style.getLength();
                    ++rowCount;
                    x = startX;
                    textY += maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap());
                    continue;
                }
                if (horizontalAlignment != 2 && g != null) break;
            }
            int y = textY;
            if (nextFm2 == null) {
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                    fm2 = ((JComponent)label).getFontMetrics(font);
                } else {
                    fm2 = fm;
                }
            } else {
                fm2 = nextFm2;
            }
            if (g != null) {
                g.setFont(font);
            }
            boolean stop = false;
            String s = textRange.text.substring(Math.min(nextRowStartIndex, textRange.text.length()));
            if (s.contains("\r") || s.contains("\n")) {
                s = this.truncatedTextSuffix;
                stop = true;
            }
            int strWidth = fm2.stringWidth(s);
            boolean wrapped = false;
            int widthLeft = endX - x;
            if (widthLeft < strWidth && widthLeft >= 0) {
                if (((WebStyledLabel)label).isLineWrap() && (((WebStyledLabel)label).getMaximumRows() > 0 && rowCount < ((WebStyledLabel)label).getMaximumRows() - 1 || ((WebStyledLabel)label).getMaximumRows() <= 0) && y + maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap()) <= labelHeight) {
                    int nextWordStartIndex;
                    wrapped = true;
                    int availLength = s.length() * widthLeft / strWidth + 1;
                    int nextRowStartIndexInSubString = 0;
                    boolean needBreak = false;
                    boolean needContinue = false;
                    int loopCount = 0;
                    do {
                        String subStringThisRow;
                        String subString;
                        int firstRowWordEndIndex;
                        int n = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length()))))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex(s, firstRowWordEndIndex);
                        if (firstRowWordEndIndex < 0) {
                            if (x != startX) {
                                boolean lastRow;
                                boolean bl = lastRow = ((WebStyledLabel)label).getMaximumRows() > 0 && rowCount >= ((WebStyledLabel)label).getMaximumRows() - 1;
                                if (horizontalAlignment != 2 && g != null) {
                                    this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStartIndex() + Math.min(nextRowStartIndex, textRange.text.length()), lastRow);
                                }
                                textY += maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap());
                                x = startX;
                                --i;
                                ++rowCount;
                                rowStartOffset = style.getStartIndex() + Math.min(nextRowStartIndex, textRange.text.length());
                                if (lastRow) {
                                    needBreak = true;
                                }
                                needContinue = true;
                                break;
                            }
                            firstRowWordEndIndex = 0;
                            nextWordStartIndex = Math.min(s.length(), availLength);
                        }
                        if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                            availLength = subString.length() * widthLeft / strWidth;
                        }
                        if (++loopCount <= 15) continue;
                        Log.error("Styled label paint error: " + textRange);
                        break;
                    } while (strWidth > widthLeft && availLength > 0);
                    if (needBreak) break;
                    if (needContinue) continue;
                    while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                        ++nextRowStartIndexInSubString;
                    }
                    s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                    strWidth = fm2.stringWidth(s);
                    charDisplayed -= textRange.text.length() - nextRowStartIndex;
                    if (displayMnemonic) {
                        if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                            displayMnemonic = true;
                            mneIndex = mnemonicIndex - charDisplayed;
                        } else {
                            displayMnemonic = false;
                        }
                    }
                    charDisplayed += s.length();
                    nextRowStartIndex += nextRowStartIndexInSubString;
                } else {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, labelHeight), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
                stop = !lineWrap || y + maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap()) > labelHeight || ((WebStyledLabel)label).getMaximumRows() > 0 && rowCount >= ((WebStyledLabel)label).getMaximumRows() - 1;
            } else if (lineWrap) {
                nextRowStartIndex = 0;
            } else if (i < this.textRanges.size() - 1) {
                String nextS;
                TextRange nextTextRange = this.textRanges.get(i + 1);
                String nextText = nextTextRange.text;
                StyleRange nextStyle = nextTextRange.styleRange;
                int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (nextStyle != null && (nextStyle.getStyle() != -1 && font.getStyle() != nextStyle.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, nextStyle.getStyle() == -1 ? font.getStyle() : nextStyle.getStyle(), size);
                    nextFm2 = ((JComponent)label).getFontMetrics(font);
                } else {
                    nextFm2 = fm;
                }
                if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, labelHeight), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, labelHeight), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                    stop = true;
                }
            }
            if (rowCount > 0 && x == startX && s.startsWith(" ")) {
                s = s.substring(1);
                strWidth = fm2.stringWidth(s);
            }
            if (horizontalAlignment == 2 && g != null) {
                Color textColor;
                if (style != null && style.isSuperscript()) {
                    y -= fm.getHeight() - fm2.getHeight();
                }
                if (style != null && style.getBackground() != null) {
                    g.setColor(style.getBackground());
                    g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
                }
                Color color = textColor = style != null && !this.ignoreColorSettings && style.getForeground() != null ? style.getForeground() : ((Component)label).getForeground();
                if (!((Component)label).isEnabled()) {
                    textColor = UIManager.getColor("Label.disabledForeground");
                }
                g.setColor(textColor);
                if (displayMnemonic) {
                    SwingUtils.drawStringUnderlineCharAt(g, s, mneIndex, x, y);
                } else {
                    SwingUtils.drawString(g, s, x, y);
                }
                if (style != null) {
                    if (style.isStrikeThrough()) {
                        int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                        g.drawLine(x, lineY, x + strWidth - 1, lineY);
                    }
                    if (style.isDoubleStrikeThrough()) {
                        int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                        g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                        g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
                    }
                    if (style.isUnderlined()) {
                        int lineY = y + 1;
                        g.drawLine(x, lineY, x + strWidth - 1, lineY);
                    }
                    if (style.isWaved()) {
                        int waveY = y + 1;
                        for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                            if (waveX + 2 <= x + strWidth - 1) {
                                g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                            }
                            if (waveX + 4 > x + strWidth - 1) continue;
                            g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                        }
                    }
                }
            }
            if (stop) {
                if (horizontalAlignment != 2 && g != null) {
                    this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, ((JLabel)label).getText().length(), true);
                }
                this.truncated = true;
                break;
            }
            if (wrapped) {
                boolean lastRow;
                boolean bl = lastRow = ((WebStyledLabel)label).getMaximumRows() > 0 && rowCount >= ((WebStyledLabel)label).getMaximumRows() - 1 || textY + maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap()) > labelHeight;
                if (horizontalAlignment != 2 && g != null) {
                    this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, style.getStartIndex() + Math.min(nextRowStartIndex, textRange.text.length()), lastRow);
                }
                textY += maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap());
                x = startX;
                --i;
                ++rowCount;
                rowStartOffset = style.getStartIndex() + Math.min(nextRowStartIndex, textRange.text.length());
                if (lastRow) {
                    break;
                }
            } else {
                x += strWidth;
            }
            if (i != this.textRanges.size() - 1 || horizontalAlignment == 2 || g == null) continue;
            this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, -1, true);
        }
        return (int)Math.ceil((double)textY / (double)maxRowHeight);
    }

    protected int getStartX(E label, int textX, Insets insets) {
        int leftMostX = 0;
        if (insets != null) {
            leftMostX += insets.left;
        }
        if (((JLabel)label).getIcon() != null) {
            int horizontalTextPosition = ((JLabel)label).getHorizontalTextPosition();
            if (horizontalTextPosition == 11 && ((Component)label).getComponentOrientation().isLeftToRight() || horizontalTextPosition == 10 && !((Component)label).getComponentOrientation().isLeftToRight()) {
                horizontalTextPosition = 4;
            }
            if (horizontalTextPosition == 4) {
                leftMostX += ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
            }
        }
        return textX < leftMostX ? leftMostX : textX;
    }

    protected int getLabelHeight(E label, Insets insets) {
        int labelHeight = ((JComponent)label).getHeight();
        if (labelHeight <= 0) {
            labelHeight = Integer.MAX_VALUE;
        }
        if (insets != null) {
            labelHeight -= insets.top + insets.bottom;
        }
        return labelHeight;
    }

    protected void paintRow(E label, Graphics2D g, int leftAlignmentX, int thisLineEndX, int rightMostX, int textY, int startOffset, int endOffset, boolean lastRow) {
        if (g == null) {
            return;
        }
        int horizontalTextPosition = ((JLabel)label).getHorizontalTextPosition();
        int horizontalAlignment = ((JLabel)label).getHorizontalAlignment();
        if (horizontalTextPosition == 11 && !((Component)label).getComponentOrientation().isLeftToRight() || horizontalTextPosition == 10 && ((Component)label).getComponentOrientation().isLeftToRight()) {
            horizontalTextPosition = 2;
        }
        if (horizontalTextPosition == 10 && !((Component)label).getComponentOrientation().isLeftToRight() || horizontalTextPosition == 11 && ((Component)label).getComponentOrientation().isLeftToRight()) {
            horizontalTextPosition = 4;
        }
        if (horizontalAlignment == 11 && !((Component)label).getComponentOrientation().isLeftToRight() || horizontalAlignment == 10 && ((Component)label).getComponentOrientation().isLeftToRight()) {
            horizontalAlignment = 2;
        }
        if (horizontalAlignment == 10 && !((Component)label).getComponentOrientation().isLeftToRight() || horizontalAlignment == 11 && ((Component)label).getComponentOrientation().isLeftToRight()) {
            horizontalAlignment = 4;
        }
        Insets insets = ((JComponent)label).getInsets();
        int textX = leftAlignmentX;
        int paintWidth = thisLineEndX - leftAlignmentX;
        if (horizontalAlignment == 4) {
            paintWidth = thisLineEndX - textX;
            textX = ((JComponent)label).getWidth() - paintWidth;
            if (insets != null) {
                textX -= insets.right;
            }
            if (((JLabel)label).getIcon() != null && horizontalTextPosition == 2) {
                textX -= ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
            }
        } else if (horizontalAlignment == 0) {
            int leftMostX = 0;
            if (horizontalTextPosition == 4 && ((JLabel)label).getIcon() != null) {
                leftMostX += ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
            }
            int labelWidth = ((JComponent)label).getWidth();
            if (insets != null) {
                labelWidth -= insets.right + insets.left;
                leftMostX += insets.left;
            }
            if (((JLabel)label).getIcon() != null && horizontalTextPosition != 0) {
                labelWidth -= ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
            }
            textX = leftMostX + (labelWidth - paintWidth) / 2;
        }
        paintWidth = Math.min(paintWidth, rightMostX - leftAlignmentX);
        int mnemonicIndex = ((JLabel)label).getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        int x = textX;
        for (int i = 0; i < this.textRanges.size() && (endOffset < 0 || charDisplayed < endOffset); ++i) {
            Color textColor;
            int strWidth;
            int widthLeft;
            FontMetrics fm2;
            boolean displayMnemonic;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            int length = style.getLength();
            if (length < 0) {
                length = textRange.text.length();
            }
            if (style.getStartIndex() + length <= startOffset) {
                charDisplayed += length;
                continue;
            }
            int nextRowStartIndex = style.getStartIndex() >= startOffset ? 0 : startOffset - style.getStartIndex();
            if (mnemonicIndex >= 0 && textRange.text.length() - nextRowStartIndex > mnemonicIndex - (charDisplayed += nextRowStartIndex)) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            } else {
                displayMnemonic = false;
            }
            int paintLength = textRange.text.length() - nextRowStartIndex;
            if (endOffset >= 0 && charDisplayed + paintLength >= endOffset) {
                paintLength = endOffset - charDisplayed;
            }
            charDisplayed += paintLength;
            int y = textY;
            if (nextFm2 == null) {
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                    fm2 = ((JComponent)label).getFontMetrics(font);
                } else {
                    fm2 = fm;
                }
            } else {
                fm2 = nextFm2;
            }
            g.setFont(font);
            String s = textRange.text.substring(Math.min(nextRowStartIndex, textRange.text.length()));
            if (startOffset > 0 && x == textX && s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.length() > paintLength) {
                s = s.substring(0, paintLength);
            }
            if (s.contains("\r") || s.contains("\n")) {
                if (textRange.styleRange.getStartIndex() + textRange.styleRange.getLength() >= endOffset) break;
                s = this.truncatedTextSuffix;
            }
            if ((widthLeft = paintWidth + textX - x) < (strWidth = fm2.stringWidth(s))) {
                if (strWidth <= 0) {
                    return;
                }
                if (((WebStyledLabel)label).isLineWrap() && !lastRow) {
                    int nextRowStartIndexInSubString;
                    int nextWordStartIndex;
                    int availLength = s.length() * widthLeft / strWidth + 1;
                    int loopCount = 0;
                    do {
                        String subStringThisRow;
                        String subString;
                        int firstRowWordEndIndex;
                        int n = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length()))))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex(s, firstRowWordEndIndex);
                        if (firstRowWordEndIndex < 0 && x == textX) {
                            firstRowWordEndIndex = 0;
                            nextWordStartIndex = Math.min(s.length(), availLength);
                        }
                        if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                            availLength = subString.length() * widthLeft / strWidth;
                        }
                        if (++loopCount <= 50) continue;
                        Log.error("Styled label paint error: " + textRange);
                        break;
                    } while (strWidth > widthLeft && availLength > 0);
                    while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                        ++nextRowStartIndexInSubString;
                    }
                    s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                    strWidth = fm2.stringWidth(s);
                    charDisplayed -= textRange.text.length() - nextRowStartIndex;
                    if (displayMnemonic) {
                        if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                            displayMnemonic = true;
                            mneIndex = mnemonicIndex - charDisplayed;
                        } else {
                            displayMnemonic = false;
                        }
                    }
                    charDisplayed += s.length();
                } else {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, ((JComponent)label).getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            } else if (!((WebStyledLabel)label).isLineWrap() && i < this.textRanges.size() - 1) {
                String nextS;
                TextRange nextTextRange = this.textRanges.get(i + 1);
                String nextText = nextTextRange.text;
                StyleRange nextStyle = nextTextRange.styleRange;
                int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (nextStyle != null && (nextStyle.getStyle() != -1 && font.getStyle() != nextStyle.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont(font, nextStyle.getStyle() == -1 ? font.getStyle() : nextStyle.getStyle(), size);
                    nextFm2 = ((JComponent)label).getFontMetrics(font);
                } else {
                    nextFm2 = fm;
                }
                if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, ((JComponent)label).getHeight()), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, ((JLabel)label).getVerticalAlignment(), ((JLabel)label).getHorizontalAlignment(), ((JLabel)label).getVerticalTextPosition(), ((JLabel)label).getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, ((JComponent)label).getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            }
            if (style != null && style.isSuperscript()) {
                y -= fm.getHeight() - fm2.getHeight();
            }
            if (style != null && style.getBackground() != null) {
                g.setColor(style.getBackground());
                g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
            }
            Color color = textColor = style != null && !this.ignoreColorSettings && style.getForeground() != null ? style.getForeground() : ((Component)label).getForeground();
            if (!((Component)label).isEnabled()) {
                textColor = UIManager.getColor("Label.disabledForeground");
            }
            g.setColor(textColor);
            if (displayMnemonic) {
                SwingUtils.drawStringUnderlineCharAt(g, s, mneIndex, x, y);
            } else {
                SwingUtils.drawString(g, s, x, y);
            }
            if (style != null) {
                if (style.isStrikeThrough()) {
                    int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isDoubleStrikeThrough()) {
                    int lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                    g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
                }
                if (style.isUnderlined()) {
                    int lineY = y + 1;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isWaved()) {
                    int waveY = y + 1;
                    for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                        if (waveX + 2 <= x + strWidth - 1) {
                            g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                        }
                        if (waveX + 4 > x + strWidth - 1) continue;
                        g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                    }
                }
            }
            x += strWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected String layoutCL(E label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        size = null;
        if (label instanceof WebStyledLabel) {
            oldPreferredWidth = label.getPreferredWidth();
            oldRows = label.getRows();
            try {
                if (label.isLineWrap() && label.getWidth() > 0) {
                    label.setPreferredWidth(label.getWidth());
                }
                size = this.getPreferredSize(label);
                if (oldPreferredWidth > 0 && oldPreferredWidth < label.getWidth()) {
                    label.setPreferredWidth(oldPreferredWidth);
                    size = this.getPreferredSize(label);
                }
                if (!label.isLineWrap() || label.getMinimumRows() <= 0) ** GOTO lbl25
                label.setPreferredWidth(0);
                label.setRows(0);
                minSize = this.getPreferredSize(label);
                if (minSize.height <= size.height) ** GOTO lbl25
                size = minSize;
            }
            finally {
                label.setPreferredWidth(oldPreferredWidth);
                label.setRows(oldRows);
            }
        } else {
            size = label.getPreferredSize();
        }
lbl25:
        // 5 sources

        textR.width = size.width;
        textR.height = size.height;
        if (label.getIcon() != null) {
            textR.width -= label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        va = label.getVerticalAlignment();
        ha = label.getHorizontalAlignment();
        vtp = label.getVerticalTextPosition();
        htp = label.getHorizontalTextPosition();
        gap = label.getIconTextGap();
        return StyledLabelUtils.layoutCompoundLabel(label, text, icon, va, ha, vtp, htp, viewR, iconR, textR, gap);
    }

    @Override
    public Dimension getPreferredSize(E label) {
        this.retrievingPreferredSize = true;
        Dimension ps = this.getPreferredSizeImpl(label);
        this.retrievingPreferredSize = false;
        return ps;
    }

    protected Dimension getPreferredSizeImpl(E label) {
        FontMetrics fm2;
        StyledLabelUtils.buildTextRanges(label, this.textRanges);
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        int defaultFontSize = font.getSize();
        boolean lineWrap = ((WebStyledLabel)label).isLineWrap() || ((JLabel)label).getText() != null && (((JLabel)label).getText().contains("\r") || ((JLabel)label).getText().contains("\n"));
        TextRange[] texts = this.textRanges.toArray(new TextRange[this.textRanges.size()]);
        int maxRowHeight = fm.getHeight();
        for (TextRange textRange : texts) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            int styleHeight = fm.getHeight();
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                fm2 = ((JComponent)label).getFontMetrics(font);
                styleHeight = fm2.getHeight();
            }
            maxRowHeight = Math.max(maxRowHeight, ++styleHeight);
        }
        int naturalRowCount = 1;
        boolean nextRowStartIndex = false;
        int width = 0;
        int maxWidth = 0;
        ArrayList<Integer> lineWidths = new ArrayList<Integer>();
        for (TextRange textRange : this.textRanges) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            String s = textRange.text.substring(0);
            if (s.startsWith("\r") || s.startsWith("\n")) {
                lineWidths.add(width);
                maxWidth = Math.max(width, maxWidth);
                width = 0;
                if (((WebStyledLabel)label).getMaximumRows() <= 0 || ++naturalRowCount < ((WebStyledLabel)label).getMaximumRows()) continue;
                break;
            }
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                fm2 = ((JComponent)label).getFontMetrics(font);
                width += fm2.stringWidth(s);
                continue;
            }
            width += fm.stringWidth(s);
        }
        lineWidths.add(width);
        int maxLineWidth = maxWidth = Math.max(width, maxWidth);
        this.preferredRowCount = naturalRowCount;
        if (lineWrap && ((WebStyledLabel)label).getPreferredWidth() <= 0 && ((WebStyledLabel)label).getRows() > 0) {
            maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, ((WebStyledLabel)label).getRows());
        }
        int preferredWidth = ((WebStyledLabel)label).getPreferredWidth();
        Insets insets = ((JComponent)label).getInsets();
        if (preferredWidth > 0 && insets != null) {
            preferredWidth -= insets.left + insets.right;
        }
        if (((JLabel)label).getIcon() != null && ((JLabel)label).getHorizontalTextPosition() != 0) {
            preferredWidth -= ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
        }
        if (lineWrap && preferredWidth > 0 && maxWidth > preferredWidth) {
            maxWidth = this.getLayoutWidth(label, preferredWidth);
        }
        if (lineWrap && ((WebStyledLabel)label).getMaximumRows() > 0 && this.preferredRowCount > ((WebStyledLabel)label).getMaximumRows()) {
            if (((WebStyledLabel)label).getPreferredWidth() <= 0) {
                maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, ((WebStyledLabel)label).getMaximumRows());
            } else {
                this.preferredRowCount = ((WebStyledLabel)label).getMaximumRows();
            }
        }
        if (lineWrap && ((WebStyledLabel)label).getPreferredWidth() <= 0 && ((WebStyledLabel)label).getMinimumRows() > 0 && this.preferredRowCount < ((WebStyledLabel)label).getMinimumRows()) {
            maxWidth = this.getMaximumWidth(label, maxWidth, naturalRowCount, ((WebStyledLabel)label).getMinimumRows());
        }
        if (this.retrievingPreferredSize && ((WebStyledLabel)label).getRows() > 0 && this.preferredRowCount > ((WebStyledLabel)label).getRows() && (((WebStyledLabel)label).getPreferredWidth() <= 0 || ((WebStyledLabel)label).getPreferredWidth() >= maxLineWidth || naturalRowCount > ((WebStyledLabel)label).getRows())) {
            this.preferredRowCount = ((WebStyledLabel)label).getRows();
            maxLineWidth = 0;
            for (int i = 0; i < lineWidths.size() && i < this.preferredRowCount; ++i) {
                maxLineWidth = Math.max(maxLineWidth, (Integer)lineWidths.get(i));
            }
        }
        Dimension dimension = new Dimension(Math.min(maxWidth, maxLineWidth), (maxRowHeight + Math.max(0, ((WebStyledLabel)label).getRowGap())) * this.preferredRowCount);
        if (((JLabel)label).getIcon() != null) {
            dimension = new Dimension(dimension.width + ((JLabel)label).getIconTextGap() + ((JLabel)label).getIcon().getIconWidth(), dimension.height);
        }
        return dimension;
    }

    protected int getLayoutWidth(E label, int maxWidth) {
        Font font = StyledLabelUtils.getFont(label);
        int defaultFontSize = font.getSize();
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        int nextRowStartIndex = 0;
        int x = 0;
        this.preferredRowCount = 1;
        for (int i = 0; i < this.textRanges.size(); ++i) {
            FontMetrics fm2;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            if (textRange.text.contains("\r") || textRange.text.contains("\n")) {
                x = 0;
                ++this.preferredRowCount;
                continue;
            }
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                fm2 = ((JComponent)label).getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = textRange.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            boolean wrapped = false;
            int widthLeft = maxWidth - x;
            if (widthLeft < strWidth) {
                int nextWordStartIndex;
                wrapped = true;
                int availLength = s.length() * widthLeft / strWidth + 1;
                int nextRowStartIndexInSubString = 0;
                boolean needBreak = false;
                boolean needContinue = false;
                int loopCount = 0;
                do {
                    String subStringThisRow;
                    String subString;
                    int firstRowWordEndIndex;
                    int n = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex(subString = s.substring(0, Math.min(availLength, s.length())))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex(s, firstRowWordEndIndex);
                    if (firstRowWordEndIndex < 0) {
                        if (x != 0) {
                            x = 0;
                            --i;
                            ++this.preferredRowCount;
                            if (((WebStyledLabel)label).getMaximumRows() > 0 && this.preferredRowCount >= ((WebStyledLabel)label).getMaximumRows()) {
                                needBreak = true;
                            }
                            needContinue = true;
                            break;
                        }
                        firstRowWordEndIndex = 0;
                        nextWordStartIndex = Math.min(s.length(), availLength);
                    }
                    if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                        availLength = subString.length() * widthLeft / strWidth;
                    }
                    if (++loopCount <= 50) continue;
                    Log.error("Styled label paint error: " + textRange);
                    break;
                } while (strWidth > widthLeft && availLength > 0);
                if (needBreak) break;
                if (needContinue) continue;
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
            } else {
                nextRowStartIndex = 0;
            }
            if (wrapped) {
                ++this.preferredRowCount;
                x = 0;
                --i;
                continue;
            }
            x += strWidth;
        }
        return maxWidth;
    }

    protected int getMaximumWidth(E label, int maxWidth, int natural, int limited) {
        int paintRows;
        int textWidth = ((JComponent)label).getWidth() - ((JComponent)label).getInsets().left - ((JComponent)label).getInsets().right;
        if (((JLabel)label).getIcon() != null) {
            textWidth -= ((JLabel)label).getIcon().getIconWidth() + ((JLabel)label).getIconTextGap();
        }
        if (natural > 1) {
            int proposedMaxWidthMin = 1;
            int proposedMaxWidthMax = maxWidth;
            this.preferredRowCount = natural;
            while (proposedMaxWidthMin < proposedMaxWidthMax) {
                int middle = (proposedMaxWidthMax + proposedMaxWidthMin) / 2;
                maxWidth = this.getLayoutWidth(label, middle);
                if (this.preferredRowCount > limited) {
                    proposedMaxWidthMin = middle + 1;
                    this.preferredRowCount = natural;
                    continue;
                }
                proposedMaxWidthMax = middle - 1;
            }
            return maxWidth + maxWidth / 20;
        }
        int estimatedWidth = maxWidth / limited + 1;
        int x = 0;
        int nextRowStartIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = ((JComponent)label).getFontMetrics(font);
        int defaultFontSize = font.getSize();
        for (int i = 0; i < this.textRanges.size(); ++i) {
            FontMetrics fm2;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
                fm2 = ((JComponent)label).getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = textRange.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            int widthLeft = estimatedWidth - x;
            if (widthLeft < strWidth) {
                int availLength = s.length() * widthLeft / strWidth + 1;
                String subString = s.substring(0, Math.min(availLength, s.length()));
                int firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex(subString);
                int nextWordStartIndex = StyledLabelUtils.findNextWordStartIndex(s, firstRowWordEndIndex);
                if (firstRowWordEndIndex < 0) {
                    firstRowWordEndIndex = nextWordStartIndex < s.length() ? StyledLabelUtils.findFirstRowWordEndIndex(s.substring(0, nextWordStartIndex)) : nextWordStartIndex;
                }
                int nextRowStartIndexInSubString = firstRowWordEndIndex + 1;
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(++nextRowStartIndexInSubString))) < widthLeft) {
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
                if (x + strWidth >= maxWidth) {
                    x = Math.max(x, strWidth);
                    break;
                }
                if (x + strWidth >= estimatedWidth) {
                    x += strWidth;
                    break;
                }
                --i;
            }
            x += strWidth;
        }
        int paintWidth = x;
        if (((JComponent)label).getInsets() != null) {
            paintWidth += ((JComponent)label).getInsets().left + ((JComponent)label).getInsets().right;
        }
        if ((paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth)) != limited) {
            maxWidth = Math.min(maxWidth, textWidth);
            while (paintRows > limited && paintWidth < maxWidth) {
                paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth += 2);
            }
            while (paintRows < limited && paintWidth > 0) {
                paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth -= 2);
            }
            x = paintWidth;
            if (((JComponent)label).getInsets() != null) {
                x -= ((JComponent)label).getInsets().left + ((JComponent)label).getInsets().right;
            }
        }
        this.preferredRowCount = limited;
        return x;
    }
}

