/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class GroupLayout
extends AbstractLayoutManager
implements SwingConstants {
    public static final String PREFERRED = "PREFERRED";
    public static final String FILL = "FILL";
    protected int orientation;
    protected int gap;
    protected Map<Component, String> constraints = new HashMap<Component, String>();

    public GroupLayout() {
        this(0);
    }

    public GroupLayout(int orientation) {
        this(orientation, 0);
    }

    public GroupLayout(int orientation, int gap) {
        this.setOrientation(orientation);
        this.setGap(gap);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        this.constraints.put(component, (String)constraints);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public void layoutContainer(Container parent) {
        int fillCount = 0;
        int preferred = 0;
        for (Component component : parent.getComponents()) {
            boolean fill = this.isFill(component);
            if (fill) {
                ++fillCount;
            }
            if (this.orientation == 0) {
                preferred += fill ? 0 : component.getPreferredSize().width;
                continue;
            }
            preferred += fill ? 0 : component.getPreferredSize().height;
        }
        if (parent.getComponentCount() > 0) {
            preferred += this.gap * (parent.getComponentCount() - 1);
        }
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - insets.left - insets.right;
        int height = size.height - insets.top - insets.bottom;
        int fillSize = this.orientation == 0 ? (fillCount > 0 && width > preferred ? (width - preferred) / fillCount : 0) : (fillCount > 0 && height > preferred ? (height - preferred) / fillCount : 0);
        int x = ltr || this.orientation == 1 ? insets.left : size.width - insets.right;
        int y = insets.top;
        for (Component component : parent.getComponents()) {
            Dimension cps = component.getPreferredSize();
            boolean fill = this.isFill(component);
            if (this.orientation == 0) {
                int w = fill ? fillSize : cps.width;
                component.setBounds(x - (ltr ? 0 : w), y, w, height);
                x += (ltr ? 1 : -1) * (w + this.gap);
                continue;
            }
            int h = fill ? fillSize : cps.height;
            component.setBounds(x, y, width, h);
            y += h + this.gap;
        }
    }

    protected Dimension getLayoutSize(Container parent, boolean minimum) {
        Insets insets = parent.getInsets();
        Dimension ps = new Dimension();
        for (Component component : parent.getComponents()) {
            boolean ignoreSize;
            Dimension cps = minimum ? component.getMinimumSize() : component.getPreferredSize();
            boolean bl = ignoreSize = minimum && this.isFill(component);
            if (this.orientation == 0) {
                ps.width = ps.width + (ignoreSize ? 1 : cps.width);
                ps.height = Math.max(ps.height, cps.height);
                continue;
            }
            ps.width = Math.max(ps.width, cps.width);
            ps.height = ps.height + (ignoreSize ? 1 : cps.height);
        }
        if (parent.getComponentCount() > 0) {
            if (this.orientation == 0) {
                ps.width += this.gap * (parent.getComponentCount() - 1);
            } else {
                ps.height += this.gap * (parent.getComponentCount() - 1);
            }
        }
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    protected boolean isFill(Component component) {
        if (this.constraints.containsKey(component)) {
            String constraint = this.constraints.get(component);
            return constraint != null && constraint.equals(FILL);
        }
        return false;
    }
}

