/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.AlphaLayerPainterStyle;
import com.alee.utils.LafUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AlphaLayerPainter<E extends JComponent>
extends AbstractPainter<E> {
    protected int squareSize = AlphaLayerPainterStyle.squareSize;
    protected Color lightSquareColor = AlphaLayerPainterStyle.lightSquareColor;
    protected Color darkSquareColor = AlphaLayerPainterStyle.darkSquareColor;

    public AlphaLayerPainter() {
    }

    public AlphaLayerPainter(int squareSize) {
        this.squareSize = squareSize;
    }

    public AlphaLayerPainter(Color lightSquareColor, Color darkSquareColor) {
        this.lightSquareColor = lightSquareColor;
        this.darkSquareColor = darkSquareColor;
    }

    public AlphaLayerPainter(int squareSize, Color lightSquareColor, Color darkSquareColor) {
        this.squareSize = squareSize;
        this.lightSquareColor = lightSquareColor;
        this.darkSquareColor = darkSquareColor;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public void setSquareSize(int squareSize) {
        this.squareSize = squareSize;
        this.repaint();
    }

    public Color getLightSquareColor() {
        return this.lightSquareColor;
    }

    public void setLightSquareColor(Color lightSquareColor) {
        this.lightSquareColor = lightSquareColor;
        this.repaint();
    }

    public Color getDarkSquareColor() {
        return this.darkSquareColor;
    }

    public void setDarkSquareColor(Color darkSquareColor) {
        this.darkSquareColor = darkSquareColor;
        this.repaint();
    }

    @Override
    public Boolean isOpaque(E c) {
        return this.lightSquareColor.getAlpha() == 255 && this.darkSquareColor.getAlpha() == 255;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        LafUtils.drawAlphaLayer(g2d, bounds.x, bounds.y, bounds.width, bounds.height, this.squareSize, this.lightSquareColor, this.darkSquareColor);
    }
}

