/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ColorPainter<E extends JComponent>
extends AbstractPainter<E> {
    protected Color color;

    public ColorPainter(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    @Override
    public Boolean isOpaque(E c) {
        return this.color != null && this.color.getAlpha() == 255;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.color != null) {
            Rectangle r = ((JComponent)c).getVisibleRect().intersection(bounds);
            if (r.width > 0 && r.height > 0) {
                g2d.setColor(this.color);
                g2d.fillRect(r.x, r.y, r.width, r.height);
            }
        }
    }
}

