/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.image.WebImage;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.StructuredTreeNodesFilter;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebExTree;
import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.StringDocumentChangeListener;
import com.alee.utils.text.TextProvider;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class WebTreeFilterField<E extends UniqueNode>
extends WebTextField {
    public static final ImageIcon settingsIcon = new ImageIcon(WebTreeFilterField.class.getResource("icons/filter/settings.png"));
    public static final ImageIcon matchCaseIcon = new ImageIcon(WebTreeFilterField.class.getResource("icons/filter/matchCase.png"));
    public static final ImageIcon useSpaceAsSeparatorIcon = new ImageIcon(WebTreeFilterField.class.getResource("icons/filter/useSpaceAsSeparator.png"));
    public static final ImageIcon searchFromStartIcon = new ImageIcon(WebTreeFilterField.class.getResource("icons/filter/searchFromStart.png"));
    protected WeakReference<WebTree<E>> tree;
    protected StructuredTreeNodesFilter<E> filter;
    protected Document document;
    protected DocumentListener documentListener;
    protected PropertyChangeListener dataProviderChangeListener;
    protected PropertyChangeListener filterChangeListener;
    protected boolean defaultTreeStateBehavior = true;
    protected TreeState treeState = null;
    protected Rectangle visibleRect = null;
    protected WebImage filterIcon;
    protected WebPopupMenu settingsMenu;
    protected WebCheckBoxMenuItem matchCaseItem;
    protected WebCheckBoxMenuItem useSpaceAsSeparatorItem;
    protected WebCheckBoxMenuItem searchFromStartItem;

    public WebTreeFilterField() {
        this(null, null);
    }

    public WebTreeFilterField(WebTree<E> tree) {
        this(tree, null);
    }

    public WebTreeFilterField(TextProvider<E> textProvider) {
        this(null, textProvider);
    }

    public WebTreeFilterField(WebTree<E> tree, TextProvider<E> textProvider) {
        this.checkTree(tree);
        this.initDefaultFilter();
        this.setTree(tree);
        this.setTextProvider(textProvider);
        this.initField();
    }

    protected void checkTree(WebTree<E> tree) {
        if (!(tree instanceof WebAsyncTree) && !(tree instanceof WebExTree)) {
            throw new RuntimeException("WebTreeFilterField is only usable with WebAsyncTree and WebExTree");
        }
    }

    protected void initDefaultFilter() {
        this.filter = new StructuredTreeNodesFilter();
    }

    protected void initField() {
        this.setLanguage("weblaf.ex.treefilter.inputprompt", new Object[0]);
        this.setHideInputPromptOnFocus(false);
        this.initFilterIcon();
        this.initSettingsMenu();
        this.initListeners();
    }

    protected void initFilterIcon() {
        this.filterIcon = new WebImage(WebTreeFilterField.class, "icons/filter/settings.png");
        this.filterIcon.setMargin(0, 2, 0, 2);
        this.filterIcon.setCursor(Cursor.getDefaultCursor());
        this.filterIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebTreeFilterField.this.settingsMenu.showBelowMiddle(WebTreeFilterField.this.filterIcon);
            }
        });
        this.setLeadingComponent(this.filterIcon);
    }

    protected void initSettingsMenu() {
        this.settingsMenu = new WebPopupMenu();
        this.matchCaseItem = new WebCheckBoxMenuItem(matchCaseIcon);
        this.matchCaseItem.setLanguage("weblaf.filter.matchcase", new Object[0]);
        this.matchCaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebTreeFilterField.this.filter.setMatchCase(WebTreeFilterField.this.matchCaseItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.matchCaseItem);
        this.useSpaceAsSeparatorItem = new WebCheckBoxMenuItem(useSpaceAsSeparatorIcon);
        this.useSpaceAsSeparatorItem.setLanguage("weblaf.filter.spaceseparator", new Object[0]);
        this.useSpaceAsSeparatorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebTreeFilterField.this.filter.setUseSpaceAsSeparator(WebTreeFilterField.this.useSpaceAsSeparatorItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.useSpaceAsSeparatorItem);
        this.searchFromStartItem = new WebCheckBoxMenuItem(searchFromStartIcon);
        this.searchFromStartItem.setLanguage("weblaf.filter.frombeginning", new Object[0]);
        this.searchFromStartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebTreeFilterField.this.filter.setSearchFromStart(WebTreeFilterField.this.searchFromStartItem.isSelected());
                WebTreeFilterField.this.updateFiltering();
            }
        });
        this.settingsMenu.add(this.searchFromStartItem);
    }

    protected void initListeners() {
        this.documentListener = new StringDocumentChangeListener(){

            @Override
            public void documentChanged(String newValue, DocumentEvent e) {
                WebTreeFilterField.this.filter.setSearchText(newValue);
                WebTreeFilterField.this.updateFiltering();
            }
        };
        this.updateDocumentListener();
        this.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WebTreeFilterField.this.updateDocumentListener();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Hotkey.ESCAPE.isTriggered(e)) {
                    WebTreeFilterField.this.clear();
                }
            }
        });
        this.dataProviderChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTreeFilterField.this.applyFieldFilter();
            }
        };
        this.getTree().addPropertyChangeListener("dataProvider", this.dataProviderChangeListener);
        this.filterChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTreeFilterField.this.applyFieldFilter();
            }
        };
        this.getTree().addPropertyChangeListener("filter", this.dataProviderChangeListener);
    }

    protected void updateDocumentListener() {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = this.getDocument();
        this.document.addDocumentListener(this.documentListener);
    }

    public void setTree(WebTree<E> tree) {
        WebTree<E> previousTree = this.getTree();
        if (previousTree != null) {
            previousTree.removePropertyChangeListener("model", this.dataProviderChangeListener);
            this.removeFieldFilter();
        }
        this.tree = new WeakReference<WebTree<E>>(tree);
        this.applyFieldFilter();
        tree.addPropertyChangeListener("model", this.dataProviderChangeListener);
    }

    public StructuredTreeNodesFilter<E> getFilter() {
        return this.filter;
    }

    public void setFilter(StructuredTreeNodesFilter<E> filter) {
        this.removeFieldFilter();
        this.filter = filter;
        this.applyFieldFilter();
    }

    protected void applyFieldFilter() {
        WebTree<E> tree = this.getTree();
        if (tree != null) {
            if (tree instanceof WebAsyncTree) {
                WebAsyncTree asyncTree = (WebAsyncTree)tree;
                this.filter.clearCache();
                Filter originalFilter = asyncTree.getFilter();
                this.filter.setOriginalFilter(originalFilter instanceof StructuredTreeNodesFilter ? ((StructuredTreeNodesFilter)originalFilter).getOriginalFilter() : originalFilter);
                asyncTree.setFilter(this.filter);
            } else if (tree instanceof WebExTree) {
                WebExTree exTree = (WebExTree)tree;
                this.filter.clearCache();
                Filter originalFilter = exTree.getFilter();
                this.filter.setOriginalFilter(originalFilter instanceof StructuredTreeNodesFilter ? ((StructuredTreeNodesFilter)originalFilter).getOriginalFilter() : originalFilter);
                exTree.setFilter(this.filter);
            }
        }
    }

    protected void removeFieldFilter() {
        WebTree<E> tree = this.getTree();
        if (tree != null) {
            Filter<E> originalFilter = this.filter.getOriginalFilter();
            if (tree instanceof WebAsyncTree) {
                ((WebAsyncTree)tree).setFilter(originalFilter);
            } else if (tree instanceof WebExTree) {
                ((WebExTree)tree).setFilter(originalFilter);
            }
            this.filter.setOriginalFilter(null);
        }
    }

    public TextProvider<E> getTextProvider() {
        return this.filter.getTextProvider();
    }

    public void setTextProvider(TextProvider<E> textProvider) {
        this.filter.setTextProvider(textProvider);
        this.updateFiltering();
    }

    public boolean isDefaultTreeStateBehavior() {
        return this.defaultTreeStateBehavior;
    }

    public void setDefaultTreeStateBehavior(boolean defaultTreeStateBehavior) {
        this.defaultTreeStateBehavior = defaultTreeStateBehavior;
    }

    public void updateFiltering() {
        WebTree<E> tree = this.getTree();
        if (tree != null) {
            if (tree instanceof WebAsyncTree) {
                this.filter.clearCache();
                ((WebAsyncTree)tree).updateSortingAndFiltering();
            } else if (tree instanceof WebExTree) {
                if (this.defaultTreeStateBehavior && !this.isEmpty() && this.treeState == null) {
                    this.treeState = tree.getTreeState();
                    this.visibleRect = tree.getVisibleRect();
                }
                this.filter.clearCache();
                ((WebExTree)tree).updateSortingAndFiltering();
                if (this.defaultTreeStateBehavior) {
                    if (this.isEmpty()) {
                        if (this.treeState != null) {
                            tree.setTreeState(this.treeState);
                            tree.scrollRectToVisible(this.visibleRect);
                            this.treeState = null;
                            this.visibleRect = null;
                        }
                    } else {
                        tree.expandAll();
                    }
                }
            }
        }
    }

    public void updateNodeAcceptance(E node) {
        WebTree<E> tree = this.getTree();
        if (tree != null) {
            if (tree instanceof WebAsyncTree) {
                this.filter.clearCache(node);
                ((WebAsyncTree)tree).updateSortingAndFiltering((AsyncUniqueNode)((UniqueNode)node).getParent());
            } else if (tree instanceof WebExTree) {
                this.filter.clearCache(node);
                ((WebExTree)tree).updateSortingAndFiltering(((UniqueNode)node).getParent());
            }
        }
    }

    public WebTree<E> getTree() {
        return this.tree != null ? (WebTree)this.tree.get() : null;
    }

    public boolean isEmpty() {
        String text = this.getText();
        return text == null || text.equals("");
    }
}

