/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.menu.AdaptivePopupMenuPainter;
import com.alee.laf.menu.PopupMenuPainter;
import com.alee.laf.menu.PopupMenuType;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WebPopupMenuStyle;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.skin.web.PopupStyle;
import com.alee.managers.style.skin.web.WebPopupPainter;
import com.alee.utils.LafUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class WebPopupMenuUI
extends BasicPopupMenuUI
implements SwingConstants,
Styleable,
ShapeProvider,
BorderMethods {
    protected Insets margin = WebPopupMenuStyle.margin;
    protected int menuSpacing = WebPopupMenuStyle.menuSpacing;
    protected boolean fixLocation = WebPopupMenuStyle.fixLocation;
    protected PopupMenuPainter painter;
    protected PropertyChangeListener popupMenuTypeUpdater;
    protected PropertyChangeListener orientationChangeListener;
    protected PropertyChangeListener visibilityChangeListener;
    protected PropertyChangeListener jdkSevenFixListener;
    protected String styleId = null;
    protected boolean transparent = false;
    protected PopupMenuWay popupMenuWay = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebPopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.transparent = ProprietaryUtils.isWindowTransparencyAllowed() || ProprietaryUtils.isWindowShapeAllowed();
        SwingUtils.setOrientation(this.popupMenu);
        SwingUtils.setHandlesEnableStateMark(this.popupMenu);
        StyleManager.applySkin(this.popupMenu);
        this.popupMenuTypeUpdater = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    Component invoker = WebPopupMenuUI.this.popupMenu.getInvoker();
                    if (invoker != null) {
                        if (invoker instanceof JMenu) {
                            if (invoker.getParent() instanceof JPopupMenu) {
                                WebPopupMenuUI.this.painter.setPopupMenuType(PopupMenuType.menuBarSubMenu);
                            } else {
                                WebPopupMenuUI.this.painter.setPopupMenuType(PopupMenuType.menuBarMenu);
                            }
                        } else if (invoker instanceof JComboBox) {
                            WebPopupMenuUI.this.painter.setPopupMenuType(PopupMenuType.comboBoxMenu);
                        } else {
                            WebPopupMenuUI.this.painter.setPopupMenuType(PopupMenuType.customPopupMenu);
                        }
                    } else {
                        WebPopupMenuUI.this.painter.setPopupMenuType(PopupMenuType.customPopupMenu);
                    }
                }
            }
        };
        this.popupMenu.addPropertyChangeListener("visible", this.popupMenuTypeUpdater);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPopupMenuUI.this.popupMenu.setVisible(false);
            }
        };
        this.popupMenu.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.visibilityChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    if (!SystemUtils.isUnix()) {
                        WebPopupMenuUI.this.installPopupSettings(SwingUtils.getWindowAncestor(WebPopupMenuUI.this.popupMenu), WebPopupMenuUI.this.popupMenu);
                    }
                } else {
                    WebPopupMenuUI.this.uninstallPopupSettings(SwingUtils.getWindowAncestor(WebPopupMenuUI.this.popupMenu), WebPopupMenuUI.this.popupMenu);
                }
            }
        };
        this.popupMenu.addPropertyChangeListener("visible", this.visibilityChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.popupMenu.removePropertyChangeListener("visible", this.popupMenuTypeUpdater);
        this.popupMenuTypeUpdater = null;
        this.popupMenu.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.orientationChangeListener = null;
        if (this.transparent) {
            this.popupMenu.removePropertyChangeListener("visible", this.visibilityChangeListener);
            this.visibilityChangeListener = null;
        } else if (SystemUtils.isJava7orAbove()) {
            this.popupMenu.removePropertyChangeListener("visible", this.jdkSevenFixListener);
            this.jdkSevenFixListener = null;
        }
        StyleManager.removeSkin(this.popupMenu);
        super.uninstallUI(c);
    }

    protected void installPopupSettings(Window window, JPopupMenu popupMenu) {
        if (window != null && this.transparent && SwingUtils.isHeavyWeightWindow(window)) {
            if (window instanceof JWindow && SystemUtils.isMac()) {
                ((JWindow)window).getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
            if (SwingUtils.isHeavyWeightWindow(window)) {
                if (ProprietaryUtils.isWindowTransparencyAllowed()) {
                    ProprietaryUtils.setWindowOpaque(window, false);
                } else if (ProprietaryUtils.isWindowShapeAllowed()) {
                    window.pack();
                    Rectangle bounds = window.getBounds();
                    ++bounds.width;
                    ++bounds.height;
                    Shape shape = ((WebPopupPainter)((Object)this.painter)).provideShape(popupMenu, bounds);
                    ProprietaryUtils.setWindowShape(window, shape);
                }
            }
        }
    }

    protected void uninstallPopupSettings(Window window, JPopupMenu popupMenu) {
        if (window != null && this.transparent && SwingUtils.isHeavyWeightWindow(window)) {
            ProprietaryUtils.setWindowOpaque(window, true);
            ProprietaryUtils.setWindowShape(window, null);
        }
    }

    @Override
    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public void setStyleId(String id) {
        this.styleId = id;
        StyleManager.applySkin(this.popupMenu);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.popupMenu, 0, StyleConstants.smallRound);
    }

    @Override
    public void updateBorder() {
        LafUtils.updateBorder(this.popupMenu, this.margin, this.painter);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public int getMenuSpacing() {
        return this.menuSpacing;
    }

    public void setMenuSpacing(int spacing) {
        this.menuSpacing = spacing;
        if (this.painter != null) {
            this.painter.setMenuSpacing(spacing);
        }
    }

    public boolean isFixLocation() {
        return this.fixLocation;
    }

    public void setFixLocation(boolean fix) {
        this.fixLocation = fix;
        if (this.painter != null) {
            this.painter.setFixLocation(fix);
        }
    }

    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
        if (this.painter != null) {
            this.painter.setPopupMenuWay(way);
        }
    }

    public PopupStyle getPopupStyle() {
        PopupStyle popupStyle = (PopupStyle)((Object)StyleManager.getPainterPropertyValue(this.popupMenu, "popupStyle"));
        return popupStyle != null ? popupStyle : WebPopupMenuStyle.popupStyle;
    }

    public void setPopupStyle(PopupStyle style) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "popupStyle", style);
    }

    public Color getBorderColor() {
        Color borderColor = (Color)StyleManager.getPainterPropertyValue(this.popupMenu, "borderColor");
        return borderColor != null ? borderColor : WebPopupMenuStyle.borderColor;
    }

    public void setBorderColor(Color color) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "borderColor", color);
    }

    public int getRound() {
        Integer round = (Integer)StyleManager.getPainterPropertyValue(this.popupMenu, "round");
        return round != null ? round : WebPopupMenuStyle.round;
    }

    public void setRound(int round) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "round", round);
    }

    public int getShadeWidth() {
        Integer shadeWidth = (Integer)StyleManager.getPainterPropertyValue(this.popupMenu, "shadeWidth");
        return shadeWidth != null ? shadeWidth : WebPopupMenuStyle.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "shadeWidth", shadeWidth);
    }

    public float getShadeTransparency() {
        Float shadeTransparency = (Float)StyleManager.getPainterPropertyValue(this.popupMenu, "shadeTransparency");
        return shadeTransparency != null ? shadeTransparency.floatValue() : WebPopupMenuStyle.shadeTransparency;
    }

    public void setShadeTransparency(float opacity) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "shadeTransparency", Float.valueOf(opacity));
    }

    public int getCornerWidth() {
        Integer cornerWidth = (Integer)StyleManager.getPainterPropertyValue(this.popupMenu, "cornerWidth");
        return cornerWidth != null ? cornerWidth : WebPopupMenuStyle.cornerWidth;
    }

    public void setCornerWidth(int width) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "cornerWidth", width);
    }

    public int getCornerAlignment() {
        Integer cornerAlignment = (Integer)StyleManager.getPainterPropertyValue(this.popupMenu, "cornerAlignment");
        return cornerAlignment != null ? cornerAlignment : WebPopupMenuStyle.cornerAlignment;
    }

    public void setCornerAlignment(int cornerAlignment) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "cornerAlignment", cornerAlignment);
    }

    public float getTransparency() {
        Float transparency = (Float)StyleManager.getPainterPropertyValue(this.popupMenu, "transparency");
        return transparency != null ? transparency.floatValue() : WebPopupMenuStyle.transparency;
    }

    public void setTransparency(float transparency) {
        StyleManager.setCustomPainterProperty(this.popupMenu, "transparency", Float.valueOf(transparency));
    }

    public Painter getPainter() {
        return LafUtils.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PopupMenuPainter properPainter = (PopupMenuPainter)LafUtils.getProperPainter(painter, PopupMenuPainter.class, AdaptivePopupMenuPainter.class);
        PainterSupport.uninstallPainter(this.popupMenu, this.painter);
        PopupMenuPainter oldPainter = this.painter;
        this.painter = properPainter;
        this.applyPainterSettings(properPainter);
        PainterSupport.installPainter(this.popupMenu, properPainter);
        LafUtils.firePainterChanged(this.popupMenu, oldPainter, properPainter);
    }

    protected void applyPainterSettings(PopupMenuPainter painter) {
        if (painter != null) {
            painter.setMenuSpacing(this.menuSpacing);
            painter.setFixLocation(this.fixLocation);
            painter.setTransparent(this.transparent);
            painter.setPopupMenuWay(this.popupMenuWay);
        }
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        Popup p;
        Component window;
        if (this.painter != null) {
            this.painter.setMenuSpacing(this.menuSpacing);
            this.painter.setFixLocation(this.fixLocation);
            this.painter.setPopupMenuWay(this.popupMenuWay);
            Point fixed = this.painter.preparePopupMenu(popup, popup.getInvoker(), x, y);
            if (this.fixLocation) {
                x = fixed.x;
                y = fixed.y;
            }
            this.popupMenuWay = null;
        }
        if ((window = (Component)ReflectUtils.callMethodSafely(p = super.getPopup(popup, x, y), "getComponent", new Object[0])) instanceof Window) {
            this.installPopupSettings((Window)window, this.popupMenu);
        }
        return p;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
    }
}

