/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.highlight;

import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class HighlightManager {
    public static List<Component> highlightComponentsWithText(String text, Component highlightBase) {
        List<Component> found = SwingUtils.findComponentsWithText(text, highlightBase);
        if (found.size() > 0) {
            HighlightManager.setHiglightedComponents(found, highlightBase);
        } else {
            HighlightManager.clearHighlightedComponents(highlightBase);
        }
        return found;
    }

    public static void setHiglightedComponent(Component highlight) {
        HighlightManager.setHiglightedComponent(highlight, null);
    }

    public static void setHiglightedComponent(Component highlight, Component highlightBase) {
        WebGlassPane wgp;
        if (highlight != null && (wgp = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(highlight))) != null) {
            wgp.clearHighlights();
            wgp.setHighlightBase(highlightBase != null ? highlightBase : wgp);
            wgp.addHighlightedComponents(highlight);
        }
    }

    public static void setHiglightedComponents(List<Component> highlights) {
        HighlightManager.setHiglightedComponents(highlights, null);
    }

    public static void setHiglightedComponents(List<Component> highlights, Component highlightBase) {
        if (highlights != null && highlights.size() > 0) {
            ArrayList<String> clearedIds = new ArrayList<String>();
            for (Component component : highlights) {
                WebGlassPane wgp = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component));
                if (wgp == null) continue;
                if (!clearedIds.contains(wgp.getId())) {
                    wgp.setHighlightBase(highlightBase != null ? highlightBase : wgp);
                    wgp.clearHighlights();
                    clearedIds.add(wgp.getId());
                }
                wgp.addHighlightedComponents(component);
            }
        }
    }

    public static void removeHigligtedComponent(Component highlight) {
        WebGlassPane wgp;
        if (highlight != null && (wgp = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(highlight))) != null) {
            wgp.removeHighlightedComponents(highlight);
        }
    }

    public static void removeHiglightedComponents(List<Component> highlights) {
        if (highlights != null && highlights.size() > 0) {
            for (Component component : highlights) {
                WebGlassPane wgp = GlassPaneManager.getGlassPane(SwingUtils.getWindowAncestor(component));
                if (wgp == null) continue;
                wgp.removeHighlightedComponents(component);
            }
        }
    }

    public static void clearHighlightedComponents(Component component) {
        HighlightManager.clearHighlightedComponents(SwingUtils.getWindowAncestor(component));
    }

    public static void clearHighlightedComponents(Window window) {
        WebGlassPane wgp = GlassPaneManager.getGlassPane(window);
        if (wgp != null) {
            wgp.clearHighlights();
        }
    }

    public static void setHighlightBase(Component highlightBase) {
        HighlightManager.setHighlightBase(SwingUtils.getWindowAncestor(highlightBase), highlightBase);
    }

    public static void setHighlightBase(Window window, Component highlightBase) {
        WebGlassPane wgp = GlassPaneManager.getGlassPane(window);
        if (wgp != null) {
            wgp.setHighlightBase(highlightBase);
        }
    }
}

