/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.LanguageInfo;
import com.alee.managers.language.data.Record;
import java.util.ArrayList;
import java.util.List;

public class LanguageUtils {
    public static String getInitialText(String text, Object ... data) {
        return LanguageManager.isCheckComponentsTextForTranslations() ? (LanguageManager.contains(text) ? LanguageManager.get(text, data) : text) : text;
    }

    public static void registerInitialLanguage(LanguageMethods component, String text, Object ... data) {
        if (LanguageManager.isCheckComponentsTextForTranslations() && LanguageManager.contains(text)) {
            component.setLanguage(text, data);
        }
    }

    public static List<String> gatherKeys(Dictionary dictionary) {
        ArrayList<String> keys = new ArrayList<String>();
        LanguageUtils.gatherKeys(dictionary.getPrefix(), dictionary, keys);
        return keys;
    }

    private static void gatherKeys(String prefix, Dictionary dictionary, List<String> keys) {
        prefix = LanguageUtils.fixKeyPrefix(prefix);
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                keys.add(prefix + record.getKey());
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                LanguageUtils.gatherKeys(LanguageUtils.combineKeyPrefix(prefix, subDictionary), subDictionary, keys);
            }
        }
    }

    public static void mergeDictionary(Dictionary dictionary, Dictionary mergeInto) {
        LanguageUtils.mergeDictionary(dictionary.getPrefix(), dictionary, mergeInto);
    }

    private static void mergeDictionary(String prefix, Dictionary dictionary, Dictionary mergeInto) {
        prefix = LanguageUtils.fixKeyPrefix(prefix);
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                Record clone = record.clone();
                clone.setKey(prefix + clone.getKey());
                mergeInto.addRecord(clone);
            }
        }
        if (dictionary.getLanguageInfos() != null) {
            for (LanguageInfo info : dictionary.getLanguageInfos()) {
                mergeInto.addLanguageInfo(info);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                LanguageUtils.mergeDictionary(LanguageUtils.combineKeyPrefix(prefix, subDictionary), subDictionary, mergeInto);
            }
        }
    }

    private static String fixKeyPrefix(String prefix) {
        return prefix != null && !prefix.equals("") && !prefix.endsWith(".") ? prefix + "." : "";
    }

    private static String combineKeyPrefix(String prefix, Dictionary dictionary) {
        String sp = dictionary.getPrefix();
        return prefix + (sp != null && !sp.equals("") ? sp : "");
    }
}

