/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.LanguageAdapter;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.WeblafTooltipLanguageSupport;
import com.alee.managers.language.updaters.WebAbstractButtonLU;
import com.alee.managers.language.updaters.WebCollapsiblePaneLU;
import com.alee.managers.language.updaters.WebDockableFrameLU;
import com.alee.managers.language.updaters.WebFileDropLU;
import com.alee.managers.language.updaters.WebFormattedTextFieldLU;
import com.alee.managers.language.updaters.WebPasswordFieldLU;
import com.alee.managers.language.updaters.WebRootPaneLU;
import com.alee.managers.language.updaters.WebTextFieldLU;
import com.alee.utils.SwingUtils;
import java.awt.ComponentOrientation;

public class WebLanguageManager {
    protected static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            LanguageManager.initialize();
            LanguageManager.registerLanguageUpdater(new WebAbstractButtonLU());
            LanguageManager.registerLanguageUpdater(new WebTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebFormattedTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebPasswordFieldLU());
            LanguageManager.registerLanguageUpdater(new WebFileDropLU());
            LanguageManager.registerLanguageUpdater(new WebCollapsiblePaneLU());
            LanguageManager.registerLanguageUpdater(new WebDockableFrameLU());
            LanguageManager.registerLanguageUpdater(new WebRootPaneLU());
            LanguageManager.setTooltipLanguageSupport(new WeblafTooltipLanguageSupport());
            LanguageManager.addLanguageListener(new LanguageAdapter(){

                @Override
                public void languageChanged(String oldLang, String newLang) {
                    ComponentOrientation oo = ComponentOrientation.getOrientation(LanguageManager.getLocale(oldLang));
                    ComponentOrientation no = ComponentOrientation.getOrientation(LanguageManager.getLocale(newLang));
                    if (oo.isLeftToRight() != no.isLeftToRight()) {
                        SwingUtils.updateGlobalOrientations();
                    }
                }
            });
        }
    }
}

