/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.TooltipConverter;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.TooltipWay;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;

@XStreamAlias(value="tooltip")
@XStreamConverter(value=TooltipConverter.class)
public final class Tooltip
implements Serializable,
Cloneable {
    private TooltipType type;
    private TooltipWay way;
    private Integer delay;
    private String text;

    public Tooltip() {
    }

    public Tooltip(String text) {
        this.setText(text);
    }

    public Tooltip(Integer delay, String text) {
        this.setDelay(delay);
        this.setText(text);
    }

    public Tooltip(TooltipWay way, String text) {
        this.setWay(way);
        this.setText(text);
    }

    public Tooltip(TooltipWay way, Integer delay, String text) {
        this.setWay(way);
        this.setDelay(delay);
        this.setText(text);
    }

    public Tooltip(TooltipType type, String text) {
        this.setType(type);
        this.setText(text);
    }

    public Tooltip(TooltipType type, TooltipWay way, Integer delay, String text) {
        this.setType(type);
        this.setWay(way);
        this.setDelay(delay);
        this.setText(text);
    }

    public TooltipType getType() {
        return this.type;
    }

    public void setType(TooltipType type) {
        this.type = type;
    }

    public TooltipWay getWay() {
        return this.way;
    }

    public void setWay(TooltipWay way) {
        this.way = way;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Tooltip clone() {
        return new Tooltip(this.type, this.way, this.delay, this.text);
    }

    public String toString() {
        return this.text + (this.type != null ? " (" + (Object)((Object)this.type) + ")" : "") + (this.delay != null ? " (" + this.delay + "ms delay)" : "") + (this.way != null ? " (" + (Object)((Object)this.way) + ")" : "");
    }
}

