/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin;

import com.alee.managers.log.Log;
import com.alee.managers.plugin.PluginManager;
import com.alee.managers.plugin.data.DetectedPlugin;
import com.alee.managers.plugin.data.InitializationStrategy;
import com.alee.managers.plugin.data.PluginDependency;
import com.alee.managers.plugin.data.PluginInformation;
import com.alee.managers.plugin.data.PluginLibrary;
import com.alee.managers.plugin.data.PluginVersion;
import java.util.List;
import javax.swing.ImageIcon;

public abstract class Plugin<T extends Plugin<T>> {
    protected PluginManager<T> pluginManager;
    protected DetectedPlugin<T> detectedPlugin;
    protected InitializationStrategy initializationStrategy;
    protected boolean enabled = true;

    public PluginManager<T> getPluginManager() {
        return this.pluginManager;
    }

    protected void setPluginManager(PluginManager<T> pluginManager) {
        this.pluginManager = pluginManager;
    }

    public DetectedPlugin<T> getDetectedPlugin() {
        return this.detectedPlugin;
    }

    protected void setDetectedPlugin(DetectedPlugin<T> detectedPlugin) {
        this.detectedPlugin = detectedPlugin;
    }

    public PluginInformation getPluginInformation() {
        return this.detectedPlugin != null ? this.detectedPlugin.getInformation() : null;
    }

    public ImageIcon getPluginLogo() {
        return this.detectedPlugin != null ? this.detectedPlugin.getLogo() : null;
    }

    public String getId() {
        return this.getPluginInformation().getId();
    }

    public String getType() {
        return this.getPluginInformation().getType();
    }

    public String getTypes() {
        return this.getPluginInformation().getTypes();
    }

    public boolean isDisableable() {
        return this.getPluginInformation().isDisableable();
    }

    public String getMainClass() {
        return this.getPluginInformation().getMainClass();
    }

    public String getTitle() {
        return this.getPluginInformation().getTitle();
    }

    public String getDescription() {
        return this.getPluginInformation().getDescription();
    }

    public PluginVersion getVersion() {
        return this.getPluginInformation().getVersion();
    }

    public List<PluginLibrary> getLibraries() {
        return this.getPluginInformation().getLibraries();
    }

    public List<PluginDependency> getDependencies() {
        return this.getPluginInformation().getDependencies();
    }

    public final InitializationStrategy getInitializationStrategy() {
        if (this.initializationStrategy == null) {
            this.initializationStrategy = this.createInitializationStrategy();
        }
        return this.initializationStrategy;
    }

    protected InitializationStrategy createInitializationStrategy() {
        return InitializationStrategy.any();
    }

    public final void disable() {
        if (this.isDisableable()) {
            if (this.enabled) {
                this.disabled();
                this.enabled = false;
            } else {
                Log.warn(this, "Plugin [ " + this.getPluginInformation() + " ] is already disabled");
            }
        } else {
            Log.error((Object)this, "Plugin [ " + this.getPluginInformation() + " ] cannot be disabled");
        }
    }

    protected void disabled() {
    }

    public final void enable() {
        if (this.isDisableable()) {
            if (!this.enabled) {
                this.enabled();
                this.enabled = true;
            } else {
                Log.warn(this, "Plugin [ " + this.getPluginInformation() + " ] is already enabled");
            }
        } else {
            Log.error((Object)this, "Plugin [ " + this.getPluginInformation() + " ] cannot be re-enabled");
        }
    }

    protected void enabled() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }
}

