/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.EncryptionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;

public class JPasswordFieldSettingsProcessor
extends SettingsProcessor<JPasswordField, String> {
    private ActionListener actionListener;
    private FocusAdapter focusAdapter;

    public JPasswordFieldSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    public String getDefaultValue() {
        String defaultValue = (String)super.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    protected void doInit(JPasswordField passwordField) {
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPasswordFieldSettingsProcessor.this.save();
            }
        };
        passwordField.addActionListener(this.actionListener);
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JPasswordFieldSettingsProcessor.this.save();
            }
        };
        passwordField.addFocusListener(this.focusAdapter);
    }

    @Override
    protected void doDestroy(JPasswordField passwordField) {
        passwordField.removeActionListener(this.actionListener);
        this.actionListener = null;
        passwordField.removeFocusListener(this.focusAdapter);
        this.focusAdapter = null;
    }

    @Override
    protected void doLoad(JPasswordField passwordField) {
        passwordField.setText(EncryptionUtils.decrypt((String)this.loadValue()));
    }

    @Override
    protected void doSave(JPasswordField passwordField) {
        this.saveValue(EncryptionUtils.encrypt(new String(passwordField.getPassword())));
    }
}

