/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.tooltip.TooltipAdapter;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TooltipManager {
    protected static int defaultDelay = 400;
    protected static boolean allowMultiplyTooltips = true;
    protected static boolean showHotkeysInTooltips = true;
    protected static boolean showHotkeysInOneTimeTooltips = false;
    protected static final Map<Component, List<WebCustomTooltip>> webTooltips = new WeakHashMap<Component, List<WebCustomTooltip>>();
    protected static final Map<Component, MouseAdapter> adapters = new WeakHashMap<Component, MouseAdapter>();
    protected static final Map<Component, WebTimer> timers = new WeakHashMap<Component, WebTimer>();
    protected static final List<WebCustomTooltip> oneTimeTooltips = new ArrayList<WebCustomTooltip>();
    protected static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof MouseWheelEvent) {
                        TooltipManager.hideAllTooltips();
                    }
                }
            }, 131072L);
        }
    }

    public static void hideAllTooltips() {
        for (Component component : CollectionUtils.copy(webTooltips.keySet())) {
            List<WebCustomTooltip> list;
            WebTimer timer = timers.get(component);
            if (timer != null) {
                timer.stop();
            }
            if ((list = webTooltips.get(component)) == null || list.size() <= 0) continue;
            for (WebCustomTooltip tooltip : CollectionUtils.copy(list)) {
                tooltip.closeTooltip();
            }
        }
        for (WebCustomTooltip tooltip : CollectionUtils.copy(oneTimeTooltips)) {
            tooltip.closeTooltip();
        }
    }

    public static WebCustomTooltip setTooltip(Component component, String tooltip) {
        return TooltipManager.setTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String tooltip) {
        return TooltipManager.setTooltip(component, icon, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(Component component, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, icon, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(component, null, tooltip, tooltipWay, delay);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(component, WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay, delay);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent tooltip) {
        return TooltipManager.setTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent tooltip, int delay) {
        return TooltipManager.setTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, delay, true);
    }

    public static WebCustomTooltip addTooltip(Component component, String tooltip) {
        return TooltipManager.addTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String tooltip) {
        return TooltipManager.addTooltip(component, icon, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(Component component, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, icon, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, null, tooltip, tooltipWay, delay);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay, delay);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent tooltip) {
        return TooltipManager.addTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent tooltip, int delay) {
        return TooltipManager.addTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent tooltip, TooltipWay tooltipWay, int delay) {
        List<WebCustomTooltip> tooltips = webTooltips.get(component);
        boolean clear = tooltips != null && tooltips.size() > 0 && !allowMultiplyTooltips;
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, delay, clear);
    }

    protected static WebCustomTooltip addTooltip(Component component, JComponent tooltip, TooltipWay tooltipWay, int delay, boolean clear) {
        if (clear) {
            TooltipManager.removeTooltips(component);
        }
        if (webTooltips.get(component) == null) {
            webTooltips.put(component, new ArrayList());
        }
        WebCustomTooltip customTooltip = new WebCustomTooltip(component, tooltip, tooltipWay, showHotkeysInTooltips);
        webTooltips.get(component).add(customTooltip);
        if (!timers.containsKey(component) || !adapters.containsKey(component)) {
            final WeakReference<Component> reference = new WeakReference<Component>(component);
            final WebTimer showTips = new WebTimer("TooltipManager.displayTimer", (long)delay);
            showTips.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window wa;
                    Component c = (Component)reference.get();
                    if (c != null && (wa = SwingUtils.getWindowAncestor(c)) != null && wa.isActive()) {
                        TooltipManager.showTooltips(c, false);
                    }
                }
            });
            showTips.setRepeats(false);
            timers.put(component, showTips);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Window window;
                    Component c = (Component)reference.get();
                    if (c != null && (window = SwingUtils.getWindowAncestor(c)).isShowing() && window.isActive()) {
                        showTips.start();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.cancelTooltips();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.cancelTooltips();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.cancelTooltips();
                }

                private void cancelTooltips() {
                    Component c = (Component)reference.get();
                    if (c != null) {
                        showTips.stop();
                        TooltipManager.hideTooltips(c);
                    }
                }
            };
            component.addMouseListener(mouseAdapter);
            adapters.put(component, mouseAdapter);
        }
        return customTooltip;
    }

    protected static void hideTooltips(Component component) {
        if (webTooltips.get(component) != null) {
            ArrayList tooltips = new ArrayList();
            tooltips.addAll(webTooltips.get(component));
            for (WebCustomTooltip tooltip : tooltips) {
                tooltip.closeTooltip();
            }
        }
    }

    public static boolean showTooltips(Component component) {
        return TooltipManager.showTooltips(component, false);
    }

    public static boolean showTooltips(Component component, boolean delayed) {
        if (webTooltips.containsKey(component) && component.isShowing()) {
            if (delayed) {
                timers.get(component).restart();
            } else {
                WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(component);
                if (webGlassPane != null) {
                    ArrayList tooltips = new ArrayList();
                    tooltips.addAll(webTooltips.get(component));
                    for (WebCustomTooltip tooltip : tooltips) {
                        webGlassPane.showComponent(tooltip);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void showAllTooltips(Component component) {
        TooltipManager.hideAllTooltips();
        TooltipManager.showAllTooltips(SwingUtils.getWindowAncestor(component));
    }

    protected static void showAllTooltips(Window window) {
        if (window.isShowing()) {
            for (Component component : webTooltips.keySet()) {
                if (SwingUtils.getWindowAncestor(component) != window || !component.isShowing()) continue;
                for (WebCustomTooltip tooltip : webTooltips.get(component)) {
                    TooltipManager.showOneTimeTooltip(tooltip, false);
                }
            }
        }
    }

    public static void showAllTooltips() {
        for (Component component : webTooltips.keySet()) {
            if (!component.isShowing()) continue;
            for (WebCustomTooltip tooltip : webTooltips.get(component)) {
                TooltipManager.showOneTimeTooltip(tooltip, false);
            }
        }
    }

    public static void installShowAllTooltipsAction(JComponent topComponent) {
        TooltipManager.installShowAllTooltipsAction(topComponent, Hotkey.F2);
    }

    public static void installShowAllTooltipsAction(final JComponent topComponent, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey(topComponent, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                TooltipManager.showAllTooltips(topComponent);
            }
        }, true);
    }

    public static void removeTooltips(Component component) {
        if (webTooltips.get(component) != null) {
            for (WebCustomTooltip tooltip : CollectionUtils.copy((Collection)webTooltips.get(component))) {
                TooltipManager.removeTooltip(component, tooltip);
            }
        }
    }

    public static void removeTooltips(Component component, WebCustomTooltip ... tooltips) {
        for (WebCustomTooltip tooltip : tooltips) {
            TooltipManager.removeTooltip(component, tooltip);
        }
    }

    public static void removeTooltips(Component component, List<WebCustomTooltip> tooltips) {
        for (WebCustomTooltip tooltip : tooltips) {
            TooltipManager.removeTooltip(component, tooltip);
        }
    }

    public static void removeTooltip(Component component, WebCustomTooltip tooltip) {
        List<WebCustomTooltip> tooltips = webTooltips.get(component);
        if (tooltips != null && tooltips.contains(tooltip)) {
            if (tooltips.size() <= 1) {
                component.removeMouseListener(adapters.get(component));
                adapters.remove(component);
                timers.get(component).stop();
                timers.remove(component);
            }
            tooltips.remove(tooltip);
            tooltip.closeTooltip();
            tooltip.destroyTooltip();
            if (tooltips.size() == 0) {
                webTooltips.remove(component);
            }
        }
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, String tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, Icon icon, String tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, icon, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.showOneTimeTooltip(component, point, null, tooltip, tooltipWay);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, Icon icon, String tooltip, TooltipWay tooltipWay) {
        WebCustomTooltip customTooltip = new WebCustomTooltip(component, icon, tooltip, tooltipWay, showHotkeysInOneTimeTooltips);
        customTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, JComponent tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, JComponent tooltip, TooltipWay tooltipWay) {
        WebCustomTooltip customTooltip = new WebCustomTooltip(component, tooltip, tooltipWay, showHotkeysInOneTimeTooltips);
        customTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(WebCustomTooltip customTooltip) {
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    protected static WebCustomTooltip showOneTimeTooltip(final WebCustomTooltip customTooltip, final boolean destroyOnClose) {
        if (customTooltip.getComponent() == null || !customTooltip.getComponent().isShowing()) {
            return null;
        }
        Window window = SwingUtils.getWindowAncestor(customTooltip.getComponent());
        final WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(window);
        if (webGlassPane == null) {
            return null;
        }
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                customTooltip.updateLocation();
            }
        };
        webGlassPane.addComponentListener(componentAdapter);
        final AWTEventListener closeListener = customTooltip.isDefaultCloseBehavior() ? new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent && event.getID() == 501) {
                    customTooltip.closeTooltip();
                }
            }
        } : null;
        customTooltip.addTooltipListener(new TooltipAdapter(){

            @Override
            public void tooltipShowing() {
                if (customTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(closeListener, 16L);
                }
            }

            @Override
            public void tooltipHidden() {
                customTooltip.removeTooltipListener(this);
                if (customTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(closeListener);
                }
                oneTimeTooltips.remove(customTooltip);
                webGlassPane.removeComponentListener(componentAdapter);
                if (destroyOnClose) {
                    customTooltip.destroyTooltip();
                }
            }
        });
        oneTimeTooltips.add(customTooltip);
        webGlassPane.showComponent(customTooltip);
        return customTooltip;
    }

    public static int getDefaultDelay() {
        return defaultDelay;
    }

    public static void setDefaultDelay(int delay) {
        defaultDelay = delay;
    }

    public static boolean isAllowMultiplyTooltips() {
        return allowMultiplyTooltips;
    }

    public static void setAllowMultiplyTooltips(boolean allowMultiplyTooltips) {
        TooltipManager.allowMultiplyTooltips = allowMultiplyTooltips;
    }

    public static boolean isShowHotkeysInTooltips() {
        return showHotkeysInTooltips;
    }

    public static void setShowHotkeysInTooltips(boolean showHotkeysInTooltips) {
        TooltipManager.showHotkeysInTooltips = showHotkeysInTooltips;
    }

    public static boolean isShowHotkeysInOneTimeTooltips() {
        return showHotkeysInOneTimeTooltips;
    }

    public static void setShowHotkeysInOneTimeTooltips(boolean showHotkeysInOneTimeTooltips) {
        TooltipManager.showHotkeysInOneTimeTooltips = showHotkeysInOneTimeTooltips;
    }
}

