/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArrayUtils {
    public static <T> List<T> asList(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    public static boolean contains(int number, int[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(long number, long[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(float number, float[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(double number, double[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(char number, char[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(byte number, byte[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(String number, String[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(Object object, Object[] array) {
        return ArrayUtils.indexOf(object, array) != -1;
    }

    public static int indexOf(int number, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long number, long[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float number, float[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double number, double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char object, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte object, byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String text, String[] array) {
        return ArrayUtils.indexOf(text, array, false);
    }

    public static int indexOf(String text, String[] array, boolean ignoreCase) {
        for (int i = 0; i < array.length; ++i) {
            String txt = array[i];
            if ((txt != null || text != null) && (txt == null || text == null || !(ignoreCase ? txt.equalsIgnoreCase(text) : txt.equals(text)))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object object, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || object == null || !obj.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] remove(T[] array, T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (mod == 0 && array[i] == object) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static int[] remove(int[] array, int index) {
        int[] newArray = new int[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static float[] remove(float[] array, float index) {
        float[] newArray = new float[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if ((float)i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static double[] remove(double[] array, double index) {
        double[] newArray = new double[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if ((double)i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static char[] remove(char[] array, char index) {
        char[] newArray = new char[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static byte[] remove(byte[] array, byte index) {
        byte[] newArray = new byte[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static boolean[] remove(boolean[] array, int index) {
        boolean[] newArray = new boolean[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] remove(T[] array, int index) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static int[] insert(int[] array, int index, int object) {
        int[] newArray = new int[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static float[] insert(float[] array, int index, float object) {
        float[] newArray = new float[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static double[] insert(double[] array, int index, double object) {
        double[] newArray = new double[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static char[] insert(char[] array, int index, char object) {
        char[] newArray = new char[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static byte[] insert(byte[] array, int index, byte object) {
        byte[] newArray = new byte[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static boolean[] insert(boolean[] array, int index, boolean object) {
        boolean[] newArray = new boolean[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] insert(T[] array, int index, T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length + 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] createArray(T[] array, int length) {
        return ArrayUtils.createArray(array.getClass().getComponentType(), length);
    }

    public static <T> T[] createArray(Class<T> classType, int length) {
        return (Object[])Array.newInstance(classType, length);
    }
}

